using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Web.Services.Protocols; 
using System.IO; 
using System.Xml.Serialization; 
using satoBEA.localhost;

namespace satoBEA
{
	/// <summary>
	/// Summary description for Input.
	/// </summary>
	public class Input : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.DataGrid DataGrid1;
		protected System.Web.UI.WebControls.Button btnBack;
		protected System.Web.UI.WebControls.Button btnPrint;
		protected System.Web.UI.WebControls.Button btnReset;
	
		//DataTable dTable; 
		private ArrayList inputText = new ArrayList();
		//int iiCount; 
		string FileName; 
		int PrintQty; 
        localhost.Immediate MyService = new localhost.Immediate(); 
		ALEPCService m_alePCService = new ALEPCService();
		protected System.Web.UI.WebControls.Label Label2;
		protected System.Web.UI.WebControls.TextBox TextBox3;
		protected System.Web.UI.WebControls.Label Label1;
		protected System.Web.UI.WebControls.TextBox TextBox2;
		protected System.Web.UI.WebControls.Label Label3;
		protected System.Web.UI.WebControls.TextBox txtSpecs;
		satoFileUtil.satoFileUtil satoUtil = new  satoFileUtil.satoFileUtil();

		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!(IsPostBack)) 
			{ 
				satoUtil.setFileName(Request.QueryString["FileName"]); 
				Reset(); 
			}

		}

		private void Reset() 
		{ 
			inputText = satoUtil.getFieldsNames() ;
			Session.Add ("strArray", inputText);
			CreateNewDataRow(); 
		}
 
		private void CreateNewDataRow() 
		{ 
			DataTable myTable = new DataTable("tblDownload"); 
			DataColumn idColumn = new DataColumn(); 
			idColumn.DataType = System.Type.GetType("System.String"); 
			idColumn.ColumnName = "txtField"; 
			myTable.Columns.Add(idColumn); 
			DataRow myRow; 
			for (int iCount = 0; iCount <= inputText.Count - 1; iCount++) 
			{ 
				myRow = myTable.NewRow(); 
				myRow["txtField"] = inputText[iCount];
//					inputText.Item[iCount]; 
				myTable.Rows.Add(myRow); 
			} 
			myRow = myTable.NewRow(); 
			myRow["txtField"] = "File name"; 
			myTable.Rows.Add(myRow); 
			myRow = myTable.NewRow(); 
			myRow["txtField"] = "Quantity of Page"; 
			myTable.Rows.Add(myRow); 
			DataGrid1.DataSource = myTable; 
			DataGrid1.DataBind(); 
		}




		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.btnBack.Click += new System.EventHandler(this.btnBack_Click);
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			this.btnReset.Click += new System.EventHandler(this.btnReset_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void btnReset_Click(object sender, System.EventArgs e)
		{
			Reset(); 
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			string FieldName; 
			string FieldValue; 
			bool OK ;
			string text_report;
			
			//DataGridItem DemoGridItem1; 
			satoUtil.SetarrFieldsName (Session["strArray"] );
			satoUtil.SetarrFieldsValue (Session["strArray"] );

			foreach(DataGridItem DemoGridItem1 in DataGrid1.Items)

			{ 
				TextBox myTextBox = ((TextBox)(DemoGridItem1.Cells[1].Controls[1])); 

				
				FieldName = DemoGridItem1.Cells[0].Text; 
				FieldValue = myTextBox.Text; 
				OK = satoUtil.setFieldValue( FieldName, FieldValue);

				if (FieldName.Equals("File name")) 
				{ 
					FileName = myTextBox.Text; 
				} 
				else if (FieldName.Equals("Quantity of Page")) 
				{ 
					PrintQty =1;
										
				} 
			} 

		
			string Specs;
			Specs = txtSpecs.Text ;

			setSpec(@Specs);

			Immediate argument = new Immediate ();

			argument.spec = MyService.spec;
			argument.epcVal = TextBox2.Text  ;

           // m_alePCService.immediate( argument);
			PCWriteReport report = m_alePCService.immediate( argument);

			text_report = printPCWriteReport(report);
			Session.Add("Result", text_report);
			Response.Redirect("./Result.aspx");
		
		}

		public bool setSpec( string aECSpec )
		{
						FileStream reader=null ;
			try
			{
				// Create an instance of the XmlSerializer.
				XmlSerializer serializer = 	new XmlSerializer(typeof(PCSpec), "http://schemas.connecterra.com/alepc");

				// Reading the XML document requires a FileStream.
				reader = new FileStream(  aECSpec, FileMode.Open, FileAccess.Read);

				// Call the Deserialize method to restore the object's state.
				MyService.spec  = (PCSpec)serializer.Deserialize(reader);
			}
			finally
			{
				// have to close the file.
				if (reader != null)	reader.Close() ;
			}
			return true;
		}

		/// <summary>
		/// Helper method to print to System.out an XML-formatted representation
		/// of the supplied programming cycle write report.
		/// </summary>
		/// <param name="cacheInfo"></param>
		/// <returns>app secific printable text of the xml report.</returns>
		private static string printPCWriteReport(PCWriteReport writeReport) 
		{
			string rpt = "Received the following Report on the PC Write attempt:\r\n\r\n" ;
			
			// use an XML serializer to convert the PCWriteReport instance to an
			// XML-formatted representation of the report contents.
			FileStream Writer=null;
			try
			{
				string tempFileName = @"c:\\temp____out.txt";
				// Create an instance of the XmlSerializer.
				XmlSerializer serializer = 	new XmlSerializer(typeof(PCWriteReport), "http://schemas.connecterra.com/alepc");

				// Reading the XML document requires a FileStream.
				// make a temp space for writing
				Writer = new FileStream( tempFileName, FileMode.Create );

				// Call the Deserialize method to restore the object's state.
				serializer.Serialize(Writer, writeReport) ;
				Writer.Flush();

				// now go back to the beginning and read it into a buffer
				Writer.Seek( 0L, System.IO.SeekOrigin.Begin ) ;
				byte[] buffer = new byte[Writer.Length+1] ;
				Writer.Read( buffer, 0, (int)Writer.Length ) ;
				for (int i=0; i<Writer.Length; i++) rpt+= ((char)buffer[i]).ToString() ;
				Writer.Close();

				// now get rid of the file
				FileInfo fi = new FileInfo(tempFileName);
				fi.Delete();
				return rpt;
			}
			catch (Exception e)
			{
				// have to catch this exception to close the file...then rethrow
				if (Writer != null)	Writer.Close() ;
				throw(e) ;
			}
		}

		private void btnBack_Click(object sender, System.EventArgs e)
		{
			Response.Redirect("./Index.aspx");
		}

	}
}
