/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.persistence;

import com.connecterra.ale.persistence.FlushException;
import com.connecterra.ale.persistence.PersistenceException;
import com.connecterra.ale.persistence.PersistenceInitializationException;
import com.connecterra.ale.persistence.PersistenceManager;
import com.connecterra.ale.persistence.PersistentObject;
import com.connecterra.i18n.I18N;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PersistenceCategory {
    private String e;
    private String[] f;
    private int d;
    private PersistenceManager.Config c;
    private Logger b;

    protected PersistenceCategory(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            throw new IllegalArgumentException("invalid null argument");
        }
        this.e = string;
        this.f = stringArray;
    }

    void b(PersistenceManager.Config config, Logger logger) {
        if (config == null || logger == null) {
            throw new IllegalArgumentException("invalid null argument");
        }
        this.c = config;
        this.b = logger;
    }

    public PersistenceManager.Config getConfig() {
        return this.c;
    }

    public Logger getLogger() {
        return this.b;
    }

    public String getFilePrefix() {
        return this.e;
    }

    protected abstract void restoreObject(String var1) throws PersistenceException, PersistenceInitializationException;

    protected abstract Collection getAllPersistentObjects();

    public void flushDirtyInfo() {
        Collection collection = this.getAllPersistentObjects();
        boolean bl = false;
        for (PersistentObject persistentObject : collection) {
            try {
                persistentObject.periodicFlush();
            }
            catch (FlushException flushException) {
                if (bl) continue;
                this.b.log(Level.WARNING, I18N.get("flushing buffered persistence data failed"), flushException);
                bl = true;
            }
        }
    }

    protected String getIdFromFile(File file) {
        int n;
        String string = file.getName();
        int n2 = string.length();
        int n3 = this.e.length() + 1;
        int n4 = string.indexOf(46, n3);
        if (n4 == -1 || n4 == n2 - 1 || !string.startsWith(this.e + ".")) {
            return null;
        }
        String string2 = string.substring(n3, n4);
        String string3 = string.substring(n4 + 1);
        boolean bl = false;
        for (n = 0; n < this.f.length; ++n) {
            if (!this.f[n].equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        try {
            n = Integer.parseInt(string2);
            if (this.d < n) {
                this.d = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string2;
    }

    public File persistFile(String string, String string2) {
        return new File(this.c.getDirectory(), this.e + "." + string + "." + string2);
    }

    Collection b(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(this.f.length);
        for (int i = 0; i < this.f.length; ++i) {
            arrayList.add(this.persistFile(string, this.f[i]));
        }
        return arrayList;
    }

    public void validateFile(File file, boolean bl) throws PersistenceException {
        if (!file.exists()) {
            if (bl) {
                throw new PersistenceException(I18N.get("{0} does not exist", file));
            }
            return;
        }
        if (!file.isFile()) {
            throw new PersistenceException(I18N.get("{0} is not a file", file));
        }
        if (!file.canRead()) {
            throw new PersistenceException(I18N.get("{0} is not readable", file));
        }
        if (!file.canWrite()) {
            throw new PersistenceException(I18N.get("{0} is not writable", file));
        }
    }

    protected String makePersistId() {
        ++this.d;
        return Integer.toString(this.d);
    }

    public void removeFile(File file) throws PersistenceException {
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            throw new PersistenceException(I18N.get("failed to delete {0}", file));
        }
    }

    public void removeObject(String string) throws PersistenceException {
        String string2 = null;
        for (int i = 0; i < this.f.length; ++i) {
            try {
                this.removeFile(this.persistFile(string, this.f[i]));
                continue;
            }
            catch (PersistenceException persistenceException) {
                string2 = string2 == null ? persistenceException.getLocalizedMessage() : string2 + I18N.getByKey("SEMICOLON_SPACE", "; ") + persistenceException.getLocalizedMessage();
            }
        }
        if (string2 != null) {
            throw new PersistenceException(I18N.get("failed to remove object {0}: {1}", (Object)string, (Object)string2));
        }
    }
}

