/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.net;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.SocketFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class DefaultSocketFactory
implements SocketFactory {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$components$net$DefaultSocketFactory == null ? (class$org$apache$axis$components$net$DefaultSocketFactory = DefaultSocketFactory.class$("org.apache.axis.components.net.DefaultSocketFactory")) : class$org$apache$axis$components$net$DefaultSocketFactory).getName());
    public static String CONNECT_TIMEOUT = "axis.client.connect.timeout";
    protected Hashtable attributes = null;
    static /* synthetic */ Class class$org$apache$axis$components$net$DefaultSocketFactory;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$Socket;

    public DefaultSocketFactory(Hashtable attributes) {
        this.attributes = attributes;
    }

    public Socket create(String host, int port, StringBuffer otherHeaders, BooleanHolder useFullURL) throws Exception {
        int timeout = 0;
        if (this.attributes != null && this.attributes.contains(CONNECT_TIMEOUT)) {
            timeout = Integer.parseInt((String)this.attributes.get(CONNECT_TIMEOUT));
        }
        TransportClientProperties tcp = TransportClientPropertiesFactory.create("http");
        Socket sock = null;
        boolean hostInNonProxyList = this.isHostInNonProxyList(host, tcp.getNonProxyHosts());
        if (tcp.getProxyUser().length() != 0) {
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(tcp.getProxyUser()).append(":").append(tcp.getProxyPassword());
            otherHeaders.append("Proxy-Authorization").append(": Basic ").append(Base64.encode(tmpBuf.toString().getBytes())).append("\r\n");
        }
        if (port == -1) {
            port = 80;
        }
        if (tcp.getProxyHost().length() == 0 || tcp.getProxyPort().length() == 0 || hostInNonProxyList) {
            sock = DefaultSocketFactory.create(host, port, timeout);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("createdHTTP00"));
            }
        } else {
            sock = DefaultSocketFactory.create(tcp.getProxyHost(), new Integer(tcp.getProxyPort()), timeout);
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("createdHTTP01", tcp.getProxyHost(), tcp.getProxyPort()));
            }
            useFullURL.value = true;
        }
        return sock;
    }

    private static Socket create(String host, int port, int timeout) throws Exception {
        boolean plain = true;
        Socket sock = null;
        try {
            Class<?> clazz = Class.forName("java.net.InetSocketAddress");
            plain = false;
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DefaultSocketFactory.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
            Object address = constructor.newInstance(host, new Integer(port));
            sock = (Socket)(class$java$net$Socket == null ? (class$java$net$Socket = DefaultSocketFactory.class$("java.net.Socket")) : class$java$net$Socket).getConstructor(new Class[0]).newInstance(new Object[0]);
            Method connect = sock.getClass().getMethod("connect", clazz.getSuperclass(), Integer.TYPE);
            connect.invoke((Object)sock, address, new Integer(timeout));
        }
        catch (Exception e) {
            if (plain) {
                sock = new Socket(host, port);
            }
            throw e;
        }
        return sock;
    }

    protected boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("match00", new String[]{"HTTPSender", host, pattern}));
            }
            if (!DefaultSocketFactory.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (isCaseSensitive && ch != strArr[i]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl36
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl36:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl37:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl51
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl51:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl52:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl92
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block27: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (!(isCaseSensitive && ch != strArr[strIdxStart + i + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block27;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl92:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl93:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

