/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.handlers;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.MessageContext;
import org.apache.axis.components.compiler.Compiler;
import org.apache.axis.components.compiler.CompilerError;
import org.apache.axis.components.compiler.CompilerFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.enum.Scope;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.JWSClassLoader;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JWSHandler
extends BasicHandler {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$handlers$JWSHandler == null ? (class$org$apache$axis$handlers$JWSHandler = JWSHandler.class$("org.apache.axis.handlers.JWSHandler")) : class$org$apache$axis$handlers$JWSHandler).getName());
    public final String OPTION_JWS_FILE_EXTENSION = "extension";
    public final String DEFAULT_JWS_FILE_EXTENSION = ".jws";
    protected static HashMap soapServices = new HashMap();
    static /* synthetic */ Class class$org$apache$axis$handlers$JWSHandler;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JWSHandler::invoke");
        }
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            log.error(Messages.getMessage("exception00"), e);
            throw AxisFault.makeFault(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setupService(MessageContext msgContext) throws Exception {
        String realpath = msgContext.getStrProp("realpath");
        String extension = (String)this.getOption("extension");
        if (extension == null) {
            extension = ".jws";
        }
        if (realpath != null && realpath.endsWith(extension)) {
            ClassLoader cl;
            File outDirectory;
            String jwsFile = realpath;
            String rel = msgContext.getStrProp("path");
            File f2 = new File(jwsFile);
            if (!f2.exists()) {
                throw new FileNotFoundException(rel);
            }
            if (rel.charAt(0) == '/') {
                rel = rel.substring(1);
            }
            int lastSlash = rel.lastIndexOf(47);
            String dir = null;
            if (lastSlash > 0) {
                dir = rel.substring(0, lastSlash);
            }
            String file = rel.substring(lastSlash + 1);
            String outdir = msgContext.getStrProp("jws.classDir");
            if (outdir == null) {
                outdir = ".";
            }
            if (dir != null) {
                outdir = outdir + File.separator + dir;
            }
            if (!(outDirectory = new File(outdir)).exists()) {
                outDirectory.mkdirs();
            }
            if (log.isDebugEnabled()) {
                log.debug("jwsFile: " + jwsFile);
            }
            String jFile = outdir + File.separator + file.substring(0, file.length() - extension.length() + 1) + "java";
            String cFile = outdir + File.separator + file.substring(0, file.length() - extension.length() + 1) + "class";
            if (log.isDebugEnabled()) {
                log.debug("jFile: " + jFile);
                log.debug("cFile: " + cFile);
                log.debug("outdir: " + outdir);
            }
            File f1 = new File(cFile);
            String clsName = null;
            if (clsName == null) {
                clsName = f2.getName();
            }
            if (clsName != null && clsName.charAt(0) == '/') {
                clsName = clsName.substring(1);
            }
            clsName = clsName.substring(0, clsName.length() - extension.length());
            clsName = clsName.replace('/', '.');
            if (log.isDebugEnabled()) {
                log.debug("ClsName: " + clsName);
            }
            if (!f1.exists() || f2.lastModified() > f1.lastModified()) {
                int rc;
                log.debug(Messages.getMessage("compiling00", jwsFile));
                log.debug(Messages.getMessage("copy00", jwsFile, jFile));
                FileReader fr = new FileReader(jwsFile);
                FileWriter fw = new FileWriter(jFile);
                char[] buf = new char[4096];
                while ((rc = fr.read(buf, 0, 4095)) >= 0) {
                    void var19_19;
                    fw.write(buf, 0, (int)var19_19);
                }
                fw.close();
                fr.close();
                log.debug("javac " + jFile);
                Compiler compiler = CompilerFactory.getCompiler();
                compiler.setClasspath(this.getDefaultClasspath(msgContext));
                compiler.setDestination(outdir);
                compiler.addFile(jFile);
                boolean result = compiler.compile();
                new File(jFile).delete();
                if (!result) {
                    new File(cFile).delete();
                    Document doc = XMLUtils.newDocument();
                    Element root = doc.createElementNS("", "Errors");
                    StringBuffer message = new StringBuffer("Error compiling ");
                    message.append(jFile);
                    message.append(":\n");
                    List errors = compiler.getErrors();
                    int count = errors.size();
                    int i = 0;
                    while (i < count) {
                        CompilerError error = (CompilerError)errors.get(i);
                        if (i > 0) {
                            message.append("\n");
                        }
                        message.append("Line ");
                        message.append(error.getStartLine());
                        message.append(", column ");
                        message.append(error.getStartColumn());
                        message.append(": ");
                        message.append(error.getMessage());
                        ++i;
                    }
                    root.appendChild(doc.createTextNode(message.toString()));
                    throw new AxisFault("Server.compileError", Messages.getMessage("badCompile00", jFile), null, new Element[]{root});
                }
                ClassUtils.removeClassLoader(clsName);
                soapServices.remove(clsName);
            }
            if ((cl = ClassUtils.getClassLoader(clsName)) == null) {
                cl = new JWSClassLoader(clsName, msgContext.getClassLoader(), cFile);
            }
            msgContext.setClassLoader(cl);
            SOAPService rpc = (SOAPService)soapServices.get(clsName);
            if (rpc == null) {
                rpc = new SOAPService(new RPCProvider());
                rpc.setName(clsName);
                rpc.setOption("className", clsName);
                rpc.setEngine(msgContext.getAxisEngine());
                String allowed = (String)this.getOption("allowedMethods");
                if (allowed == null) {
                    allowed = "*";
                }
                rpc.setOption("allowedMethods", allowed);
                String scope = (String)this.getOption("scope");
                if (scope == null) {
                    scope = Scope.DEFAULT.getName();
                }
                rpc.setOption("scope", scope);
                rpc.getInitializedServiceDesc(msgContext);
                soapServices.put(clsName, rpc);
            }
            rpc.setEngine(msgContext.getAxisEngine());
            rpc.init();
            msgContext.setService(rpc);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JWSHandler::invoke");
        }
    }

    private String getDefaultClasspath(MessageContext msgContext) {
        StringBuffer classpath = new StringBuffer();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.fillClassPath(cl, classpath);
        String webBase = (String)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION);
        if (webBase != null) {
            classpath.append(webBase + File.separatorChar + "classes" + File.pathSeparatorChar);
            try {
                String libBase = webBase + File.separatorChar + "lib";
                File libDir = new File(libBase);
                String[] jarFiles = libDir.list();
                int i = 0;
                while (i < jarFiles.length) {
                    String jarFile = jarFiles[i];
                    if (jarFile.endsWith(".jar")) {
                        classpath.append(libBase + File.separatorChar + jarFile + File.pathSeparatorChar);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.getClassPathFromDirectoryProperty(classpath, "axis.ext.dirs");
        this.getClassPathFromProperty(classpath, "org.apache.catalina.jsp_classpath");
        this.getClassPathFromProperty(classpath, "ws.ext.dirs");
        this.getClassPathFromProperty(classpath, "com.ibm.websphere.servlet.application.classpath");
        this.getClassPathFromProperty(classpath, "java.class.path");
        this.getClassPathFromDirectoryProperty(classpath, "java.ext.dirs");
        this.getClassPathFromProperty(classpath, "sun.boot.class.path");
        return classpath.toString();
    }

    private void getClassPathFromDirectoryProperty(StringBuffer classpath, String property) {
        String dirs = AxisProperties.getProperty(property);
        String path = null;
        try {
            path = this.expandDirs(dirs);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (path != null) {
            classpath.append(path);
            classpath.append(File.pathSeparatorChar);
        }
    }

    private void getClassPathFromProperty(StringBuffer classpath, String property) {
        String path = AxisProperties.getProperty(property);
        if (path != null) {
            classpath.append(path);
            classpath.append(File.pathSeparatorChar);
        }
    }

    private void fillClassPath(ClassLoader cl, StringBuffer classpath) {
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls = ((URLClassLoader)cl).getURLs();
                int i = 0;
                while (urls != null && i < urls.length) {
                    block12: {
                        String path = urls[i].getPath();
                        if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
                            path = path.substring(1);
                        }
                        classpath.append(URLDecoder.decode(path));
                        classpath.append(File.pathSeparatorChar);
                        File file = new File(urls[i].getFile());
                        if (file.isFile()) {
                            FileInputStream fis = null;
                            try {
                                Attributes attributes;
                                JarFile jar;
                                Manifest manifest;
                                fis = new FileInputStream(file);
                                if (JWSHandler.isJar(fis) && (manifest = (jar = new JarFile(file)).getManifest()) != null && (attributes = manifest.getMainAttributes()) != null) {
                                    String s = attributes.getValue(Attributes.Name.CLASS_PATH);
                                    String base = file.getParent();
                                    if (s != null) {
                                        StringTokenizer st = new StringTokenizer(s, " ");
                                        while (st.hasMoreTokens()) {
                                            String t = st.nextToken();
                                            classpath.append(base + File.separatorChar + t);
                                            classpath.append(File.pathSeparatorChar);
                                        }
                                    }
                                }
                            }
                            catch (IOException ioe) {
                                if (fis == null) break block12;
                                try {
                                    fis.close();
                                }
                                catch (IOException ioe2) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            cl = cl.getParent();
        }
    }

    private String expandDirs(String dirPaths) {
        StringTokenizer st = new StringTokenizer(dirPaths, File.pathSeparator);
        StringBuffer buffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            String d = st.nextToken();
            File dir = new File(d);
            if (!dir.isDirectory()) continue;
            File[] files = dir.listFiles(new JavaArchiveFilter());
            int i = 0;
            while (i < files.length) {
                buffer.append(files[i]).append(File.pathSeparator);
                ++i;
            }
        }
        return buffer.toString();
    }

    public static boolean isJar(InputStream is) {
        try {
            JarInputStream jis = new JarInputStream(is);
            if (jis.getNextEntry() != null) {
                return true;
            }
        }
        catch (IOException ioe) {}
        return false;
    }

    public void generateWSDL(MessageContext msgContext) throws AxisFault {
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            log.error(Messages.getMessage("exception00"), e);
            throw AxisFault.makeFault(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JavaArchiveFilter
    implements FileFilter {
        JavaArchiveFilter() {
        }

        public boolean accept(File file) {
            String name = file.getName().toLowerCase();
            return name.endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

