/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.axis.adapters;

import com.connecterra.ale.api.ECCountReportOutputSpec;
import com.connecterra.ale.api.ECListReportOutputSpec;
import com.connecterra.ale.api.ECReportOutputSpec;
import com.connecterra.ale.api.ECReportSetSpec;
import com.connecterra.ale.api.ECReportSpec;
import com.connecterra.ale.axis.AxisALEFactory;
import com.connecterra.ale.axis.schema.ExcludePatterns;
import com.connecterra.ale.axis.schema.FilterSpec;
import com.connecterra.ale.axis.schema.IncludePatterns;
import com.connecterra.ale.axis.schema.ReportOutputSpec;
import com.connecterra.ale.axis.schema.ReportSetSpec;
import com.connecterra.ale.axis.schema.ReportSpec;
import com.connecterra.ale.axis.schema.ReportType;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ECReportSpecAdapter
implements ECReportSpec {
    private ReportSpec d;
    private List c;
    private List b;

    public static ReportSpec aleToAxis(ECReportSpec eCReportSpec) {
        if (eCReportSpec instanceof ECReportSpecAdapter) {
            return ((ECReportSpecAdapter)eCReportSpec).getAxisReportSpec();
        }
        return new ECReportSpecAdapter(eCReportSpec).getAxisReportSpec();
    }

    private ECReportSpecAdapter(ECReportSpec eCReportSpec) {
        this.d = new ReportSpec();
        this.setName(eCReportSpec.getName());
        this.setReportIfEmpty(eCReportSpec.getReportIfEmpty());
        this.setIsEssential(eCReportSpec.isEssential());
        this.setReportSetSpec(eCReportSpec.getReportSetSpec());
        this.setReportOutputSpec(eCReportSpec.getReportOutputSpec());
        this.setApplicationData(eCReportSpec.getApplicationData());
        this.c = new ArrayList(eCReportSpec.getIncludePatterns());
        this.b = new ArrayList(eCReportSpec.getExcludePatterns());
    }

    public ECReportSpecAdapter(ReportSpec reportSpec) throws URISyntaxException {
        this.d = reportSpec;
        this.b();
    }

    public ReportSpec getAxisReportSpec() {
        this.c();
        return this.d;
    }

    private void b() throws URISyntaxException {
        int n;
        String[] stringArray;
        FilterSpec filterSpec = this.d.getFilterSpec();
        if (filterSpec != null && filterSpec.getIncludePatterns() != null && filterSpec.getIncludePatterns().getIncludePattern() != null) {
            stringArray = filterSpec.getIncludePatterns().getIncludePattern();
            this.c = new ArrayList(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                this.c.add(new URI(stringArray[n]));
            }
        } else {
            this.c = new ArrayList();
        }
        if (filterSpec != null && filterSpec.getExcludePatterns() != null && filterSpec.getExcludePatterns().getExcludePattern() != null) {
            stringArray = filterSpec.getExcludePatterns().getExcludePattern();
            this.b = new ArrayList(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                this.b.add(new URI(stringArray[n]));
            }
        } else {
            this.b = new ArrayList();
        }
    }

    private void c() {
        URI uRI;
        String[] stringArray;
        if (this.c.size() == 0 && this.b.size() == 0) {
            this.d.setFilterSpec(null);
            return;
        }
        FilterSpec filterSpec = this.d.getFilterSpec();
        if (filterSpec == null) {
            filterSpec = new FilterSpec();
            this.d.setFilterSpec(filterSpec);
        }
        if (this.c.size() > 0) {
            stringArray = new String[this.c.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                uRI = (URI)this.c.get(i);
                stringArray[i] = uRI.toString();
            }
            IncludePatterns includePatterns = new IncludePatterns();
            includePatterns.setIncludePattern(stringArray);
            filterSpec.setIncludePatterns(includePatterns);
        } else {
            filterSpec.setIncludePatterns(null);
        }
        if (this.b.size() > 0) {
            stringArray = new String[this.b.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                uRI = (URI)this.b.get(i);
                stringArray[i] = uRI.toString();
            }
            ExcludePatterns excludePatterns = new ExcludePatterns();
            excludePatterns.setExcludePattern(stringArray);
            filterSpec.setExcludePatterns(excludePatterns);
        } else {
            filterSpec.setExcludePatterns(null);
        }
    }

    public String getName() {
        return this.d.getReportName();
    }

    public void setName(String string) {
        this.d.setReportName(string);
    }

    public boolean getReportIfEmpty() {
        return this.d.isReportIfEmpty();
    }

    public void setReportIfEmpty(boolean bl) {
        this.d.setReportIfEmpty(bl);
    }

    public boolean isEssential() {
        return this.d.isEssential();
    }

    public void setIsEssential(boolean bl) {
        this.d.setEssential(bl);
    }

    public ECReportSetSpec getReportSetSpec() {
        ReportSetSpec reportSetSpec = this.d.getReportSetSpec();
        if (reportSetSpec == ReportSetSpec.CURRENT) {
            return ECReportSetSpec.CURRENT;
        }
        if (reportSetSpec == ReportSetSpec.ADDITIONS) {
            return ECReportSetSpec.ADDITIONS;
        }
        if (reportSetSpec == ReportSetSpec.DELETIONS) {
            return ECReportSetSpec.DELETIONS;
        }
        return null;
    }

    public void setReportSetSpec(ECReportSetSpec eCReportSetSpec) {
        ReportSetSpec reportSetSpec = null;
        if (eCReportSetSpec == ECReportSetSpec.CURRENT) {
            reportSetSpec = ReportSetSpec.CURRENT;
        } else if (eCReportSetSpec == ECReportSetSpec.ADDITIONS) {
            reportSetSpec = ReportSetSpec.ADDITIONS;
        } else if (eCReportSetSpec == ECReportSetSpec.DELETIONS) {
            reportSetSpec = ReportSetSpec.DELETIONS;
        }
        this.d.setReportSetSpec(reportSetSpec);
    }

    public List getIncludePatterns() {
        return Collections.unmodifiableList(this.c);
    }

    public void setIncludePatterns(List list) {
        this.c.clear();
        this.addIncludePatterns(list);
    }

    public void addIncludePattern(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("illegal null argument"));
        }
        if (this.c.contains(uRI)) {
            return;
        }
        this.c.add(uRI);
    }

    public void addIncludePatterns(List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addIncludePattern((URI)iterator.next());
        }
    }

    public List getExcludePatterns() {
        return Collections.unmodifiableList(this.b);
    }

    public void setExcludePatterns(List list) {
        this.b.clear();
        this.addExcludePatterns(list);
    }

    public void addExcludePattern(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("illegal null argument"));
        }
        if (this.b.contains(uRI)) {
            return;
        }
        this.b.add(uRI);
    }

    public void addExcludePatterns(List list) {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addExcludePattern((URI)iterator.next());
        }
    }

    public ECReportOutputSpec getReportOutputSpec() {
        ReportOutputSpec reportOutputSpec = this.d.getReportOutputSpec();
        if (reportOutputSpec == null) {
            return null;
        }
        ReportType reportType = reportOutputSpec.getReportType();
        if (reportType == ReportType.LIST) {
            return AxisALEFactory.getInstance().createECListReportOutputSpec();
        }
        if (reportType == ReportType.COUNT) {
            return AxisALEFactory.getInstance().createECCountReportOutputSpec();
        }
        return null;
    }

    public void setReportOutputSpec(ECReportOutputSpec eCReportOutputSpec) {
        ReportOutputSpec reportOutputSpec = new ReportOutputSpec();
        if (eCReportOutputSpec instanceof ECListReportOutputSpec) {
            reportOutputSpec.setReportType(ReportType.LIST);
        } else if (eCReportOutputSpec instanceof ECCountReportOutputSpec) {
            reportOutputSpec.setReportType(ReportType.COUNT);
        } else if (eCReportOutputSpec == null) {
            reportOutputSpec.setReportType(null);
        } else {
            throw new IllegalArgumentException(I18N.get("output spec is not list or count"));
        }
        this.d.setReportOutputSpec(reportOutputSpec);
    }

    public String getApplicationData() {
        return this.d.getApplicationData();
    }

    public void setApplicationData(String string) {
        this.d.setApplicationData(string);
    }

    public List getGroupSpec() {
        return Collections.EMPTY_LIST;
    }

    public void setGroupSpec(List list) {
        throw new UnsupportedOperationException();
    }

    public boolean reportOnlyOnChange() {
        return false;
    }

    public void setReportOnlyOnChange(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean getIncludeCount() {
        return this.getReportOutputSpec() instanceof ECCountReportOutputSpec;
    }

    public void setIncludeCount(boolean bl) {
        if (!(this.getReportOutputSpec() instanceof ECListReportOutputSpec) && bl) {
            this.setReportOutputSpec(AxisALEFactory.getInstance().createECCountReportOutputSpec());
        }
    }

    public boolean getIncludeEPC() {
        return false;
    }

    public void setIncludeEPC(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean getIncludeTag() {
        return this.getReportOutputSpec() instanceof ECListReportOutputSpec;
    }

    public void setIncludeTag(boolean bl) {
        if (bl) {
            this.setReportOutputSpec(AxisALEFactory.getInstance().createECListReportOutputSpec());
        }
    }

    public boolean getIncludeRawHex() {
        return false;
    }

    public void setIncludeRawHex(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean getIncludeRawDecimal() {
        return false;
    }

    public void setIncludeRawDecimal(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public List getIncludedMemoryFields() {
        return Collections.EMPTY_LIST;
    }

    public void addIncludedMemoryField(URI uRI) {
        throw new UnsupportedOperationException();
    }

    public int getStableCount() {
        return 0;
    }

    public void setStableCount(int n) {
        throw new UnsupportedOperationException();
    }

    public void setIncludedMemoryFields(List list) {
        throw new UnsupportedOperationException();
    }
}

