/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.client;

import com.connecterra.ale.api.ALE;
import com.connecterra.ale.api.ALEFactory;
import com.connecterra.ale.api.DuplicateNameException;
import com.connecterra.ale.api.ECSpecInfo;
import com.connecterra.ale.api.ECSpecValidationException;
import com.connecterra.ale.api.ECSubscriptionControls;
import com.connecterra.ale.api.ECSubscriptionInfo;
import com.connecterra.ale.api.EngineException;
import com.connecterra.ale.api.InvalidURIException;
import com.connecterra.ale.axis.AxisEPCglobalALEFactory;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECReportsAdapter;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECSpecAdapter;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECSpecInfoAdapter;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECSubscriptionControlsAdapter;
import com.connecterra.ale.axis.adapters.epcglobal.ale.ECSubscriptionInfoAdapter;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECReports;
import com.connecterra.ale.axis.schema.epcglobal.ale.ECSpec;
import com.connecterra.ale.axis.schema.epcglobalExtensions.ale.EventCycleSpecInfo;
import com.connecterra.ale.axis.schema.epcglobalExtensions.ale.EventCycleSubscriptionInfo;
import com.connecterra.ale.axis.service.epcglobal.ale.ALEServiceBindingStub;
import com.connecterra.ale.axis.service.epcglobal.ale.ALEServicePortType;
import com.connecterra.ale.axis.service.epcglobal.ale.ArrayOfString;
import com.connecterra.ale.axis.service.epcglobal.ale.Define;
import com.connecterra.ale.axis.service.epcglobal.ale.DuplicateSubscriptionException;
import com.connecterra.ale.axis.service.epcglobal.ale.EPCglobalALEServiceLocator;
import com.connecterra.ale.axis.service.epcglobal.ale.EmptyParms;
import com.connecterra.ale.axis.service.epcglobal.ale.GetECSpec;
import com.connecterra.ale.axis.service.epcglobal.ale.GetECSpecInfo;
import com.connecterra.ale.axis.service.epcglobal.ale.GetECSubscriptionInfo;
import com.connecterra.ale.axis.service.epcglobal.ale.GetSubscribers;
import com.connecterra.ale.axis.service.epcglobal.ale.Immediate;
import com.connecterra.ale.axis.service.epcglobal.ale.ImplementationException;
import com.connecterra.ale.axis.service.epcglobal.ale.NoSuchNameException;
import com.connecterra.ale.axis.service.epcglobal.ale.NoSuchSubscriberException;
import com.connecterra.ale.axis.service.epcglobal.ale.Poll;
import com.connecterra.ale.axis.service.epcglobal.ale.Redefine;
import com.connecterra.ale.axis.service.epcglobal.ale.Subscribe;
import com.connecterra.ale.axis.service.epcglobal.ale.SubscribeWithControls;
import com.connecterra.ale.axis.service.epcglobal.ale.Suspend;
import com.connecterra.ale.axis.service.epcglobal.ale.Undefine;
import com.connecterra.ale.axis.service.epcglobal.ale.Unsubscribe;
import com.connecterra.ale.axis.service.epcglobal.ale.Unsuspend;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;

public class SOAPALEClient
implements ALE {
    private static Logger e = Logger.getLogger("com.connecterra.ale.client.SOAPALEClient");
    private ALEServicePortType d;

    public SOAPALEClient(URL uRL) throws RemoteException {
        if (uRL == null) {
            throw new IllegalArgumentException(I18N.get("Specified ALE Service URL is null"));
        }
        Logger logger = Logger.getLogger("org.apache.axis");
        logger.setLevel(Level.OFF);
        e.fine("Instantiating locator");
        EPCglobalALEServiceLocator ePCglobalALEServiceLocator = new EPCglobalALEServiceLocator();
        e.fine("Connecting to ALEService at " + uRL + "...");
        try {
            this.d = ePCglobalALEServiceLocator.getEPCglobalALEService(uRL);
        }
        catch (ServiceException serviceException) {
            throw new RemoteException(serviceException.getMessage(), serviceException);
        }
        this.setTimeout(600000L);
        e.fine("Connection established to ALEService.");
    }

    public void setTimeout(long l) {
        ((ALEServiceBindingStub)this.d).setTimeout((int)l);
    }

    public long getTimeout() {
        return ((ALEServiceBindingStub)this.d).getTimeout();
    }

    public static ALEFactory staticGetALEFactory() {
        return AxisEPCglobalALEFactory.getInstance();
    }

    public ALEFactory getALEFactory() {
        return SOAPALEClient.staticGetALEFactory();
    }

    public String getALEID() throws RemoteException, EngineException {
        try {
            e.fine("Invoking ALEService.getALEID...");
            return this.d.getALEID(new EmptyParms()).getALEID();
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public void define(String string, com.connecterra.ale.api.ECSpec eCSpec) throws DuplicateNameException, ECSpecValidationException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (eCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec is null."));
        }
        Define define = new Define();
        define.setSpecName(string);
        define.setSpec(ECSpecAdapter.aleToAxis(eCSpec));
        try {
            e.fine("Invoking ALEService.define...");
            this.d.define(define);
            e.fine("Returned from ALEService.define.");
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.DuplicateNameException duplicateNameException) {
            throw new DuplicateNameException(duplicateNameException.getReason(), duplicateNameException);
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.ECSpecValidationException eCSpecValidationException) {
            throw new ECSpecValidationException(eCSpecValidationException.getReason(), eCSpecValidationException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public void redefine(String string, com.connecterra.ale.api.ECSpec eCSpec) throws com.connecterra.ale.api.NoSuchNameException, ECSpecValidationException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (eCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec is null."));
        }
        Redefine redefine = new Redefine();
        redefine.setSpecName(string);
        redefine.setSpec(ECSpecAdapter.aleToAxis(eCSpec));
        try {
            e.fine("Invoking ALEService.redefine...");
            this.d.redefine(redefine);
            e.fine("Returned from ALEService.redefine.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.ECSpecValidationException eCSpecValidationException) {
            throw new ECSpecValidationException(eCSpecValidationException.getReason(), eCSpecValidationException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public void suspend(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Suspend suspend = new Suspend();
        suspend.setSpecName(string);
        try {
            e.fine("Invoking ALEService.suspend...");
            this.d.suspend(suspend);
            e.fine("Returned from ALEService.suspend.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public void unsuspend(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Unsuspend unsuspend = new Unsuspend();
        unsuspend.setSpecName(string);
        try {
            e.fine("Invoking ALEService.unsuspend...");
            this.d.unsuspend(unsuspend);
            e.fine("Returned from ALEService.unsuspend.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public void undefine(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Undefine undefine = new Undefine();
        undefine.setSpecName(string);
        try {
            e.fine("Invoking ALEService.undefine...");
            this.d.undefine(undefine);
            e.fine("Returned from ALEService.undefine.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public com.connecterra.ale.api.ECSpec get(String string) throws RemoteException, EngineException {
        try {
            return this.getECSpec(string);
        }
        catch (com.connecterra.ale.api.NoSuchNameException noSuchNameException) {
            throw new EngineException(noSuchNameException.getMessage(), noSuchNameException.getCause());
        }
    }

    public com.connecterra.ale.api.ECSpec getECSpec(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        ECSpec eCSpec;
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        GetECSpec getECSpec = new GetECSpec();
        getECSpec.setSpecName(string);
        try {
            e.fine("Invoking ALEService.getECSpec...");
            eCSpec = this.d.getECSpec(getECSpec);
            e.fine("Returned from ALEService.getECSpec.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        if (eCSpec == null) {
            return null;
        }
        try {
            return new ECSpecAdapter(eCSpec);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public List listECSpecNames() throws RemoteException, EngineException {
        return this.getECSpecNames();
    }

    public List getECSpecNames() throws RemoteException, EngineException {
        ArrayOfString arrayOfString;
        try {
            e.fine("Calling ALEService.getECSpecNames...");
            arrayOfString = this.d.getECSpecNames(new EmptyParms());
            e.fine("Returned from ALEService.getECSpecNames.");
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        return SOAPALEClient.c(arrayOfString);
    }

    public void subscribe(String string, URI uRI) throws com.connecterra.ale.api.NoSuchNameException, InvalidURIException, com.connecterra.ale.api.DuplicateSubscriptionException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        Subscribe subscribe = new Subscribe();
        subscribe.setSpecName(string);
        subscribe.setNotificationURI(uRI.toString());
        try {
            e.fine("Invoking ALEService.subscribe...");
            this.d.subscribe(subscribe);
            e.fine("Returned from ALEService.subscribe.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.InvalidURIException invalidURIException) {
            throw new InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (DuplicateSubscriptionException duplicateSubscriptionException) {
            throw new com.connecterra.ale.api.DuplicateSubscriptionException(duplicateSubscriptionException.getReason(), duplicateSubscriptionException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public void subscribe(String string, URI uRI, ECSubscriptionControls eCSubscriptionControls) throws com.connecterra.ale.api.NoSuchNameException, InvalidURIException, com.connecterra.ale.api.DuplicateSubscriptionException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        if (eCSubscriptionControls == null) {
            throw new IllegalArgumentException(I18N.get("Specified controls are null."));
        }
        SubscribeWithControls subscribeWithControls = new SubscribeWithControls();
        subscribeWithControls.setSpecName(string);
        subscribeWithControls.setNotificationURI(uRI.toString());
        subscribeWithControls.setControls(ECSubscriptionControlsAdapter.aleToAxis(eCSubscriptionControls));
        try {
            e.fine("Invoking ALEService.subscribe...");
            this.d.subscribeWithControls(subscribeWithControls);
            e.fine("Returned from ALEService.subscribe.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.InvalidURIException invalidURIException) {
            throw new InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (DuplicateSubscriptionException duplicateSubscriptionException) {
            throw new com.connecterra.ale.api.DuplicateSubscriptionException(duplicateSubscriptionException.getReason(), duplicateSubscriptionException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public void unsubscribe(String string, URI uRI) throws com.connecterra.ale.api.NoSuchNameException, com.connecterra.ale.api.NoSuchSubscriberException, InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        Unsubscribe unsubscribe = new Unsubscribe();
        unsubscribe.setSpecName(string);
        unsubscribe.setNotificationURI(uRI.toString());
        try {
            e.fine("Invoking ALEService.unsubscribe...");
            this.d.unsubscribe(unsubscribe);
            e.fine("Returned from ALEService.unsubscribe.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (NoSuchSubscriberException noSuchSubscriberException) {
            throw new com.connecterra.ale.api.NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.InvalidURIException invalidURIException) {
            throw new InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
    }

    public List listSubscribers(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        return this.getSubscribers(string);
    }

    public List getSubscribers(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        GetSubscribers getSubscribers = new GetSubscribers();
        getSubscribers.setSpecName(string);
        ArrayOfString arrayOfString = null;
        try {
            e.fine("Calling ALEService.getSubscribers...");
            arrayOfString = this.d.getSubscribers(getSubscribers);
            e.fine("Returned from ALEService.getSubscribers.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        try {
            return SOAPALEClient.b(arrayOfString);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public ECSpecInfo getECSpecInfo(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        GetECSpecInfo getECSpecInfo = new GetECSpecInfo();
        getECSpecInfo.setSpecName(string);
        EventCycleSpecInfo eventCycleSpecInfo = null;
        try {
            e.fine("Invoking ALEService.getECSpecInfo...");
            eventCycleSpecInfo = this.d.getECSpecInfo(getECSpecInfo);
            e.fine("Returned from ALEService.getECSpecInfo.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        if (eventCycleSpecInfo == null) {
            return null;
        }
        return new ECSpecInfoAdapter(eventCycleSpecInfo);
    }

    public ECSubscriptionInfo getECSubscriptionInfo(String string, URI uRI) throws com.connecterra.ale.api.NoSuchNameException, com.connecterra.ale.api.NoSuchSubscriberException, RemoteException, InvalidURIException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified subscriber URI is null."));
        }
        GetECSubscriptionInfo getECSubscriptionInfo = new GetECSubscriptionInfo();
        getECSubscriptionInfo.setSpecName(string);
        getECSubscriptionInfo.setSubscriber(uRI.toString());
        EventCycleSubscriptionInfo eventCycleSubscriptionInfo = null;
        try {
            e.fine("Invoking ALEService.getECSubscriptionInfo...");
            eventCycleSubscriptionInfo = this.d.getECSubscriptionInfo(getECSubscriptionInfo);
            e.fine("Returned from ALEService.getECSubscriptionInfo.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (NoSuchSubscriberException noSuchSubscriberException) {
            throw new com.connecterra.ale.api.NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.InvalidURIException invalidURIException) {
            throw new InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        if (eventCycleSubscriptionInfo == null) {
            return null;
        }
        return new ECSubscriptionInfoAdapter(eventCycleSubscriptionInfo);
    }

    public com.connecterra.ale.api.ECReports poll(String string) throws InterruptedException, com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Poll poll = new Poll();
        poll.setSpecName(string);
        ECReports eCReports = null;
        try {
            e.fine("Invoking ALEService.poll...");
            eCReports = this.d.poll(poll);
            e.fine("Returned from ALEService.poll.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        if (eCReports == null) {
            return null;
        }
        try {
            return new ECReportsAdapter(eCReports);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public com.connecterra.ale.api.ECReports immediate(com.connecterra.ale.api.ECSpec eCSpec) throws InterruptedException, ECSpecValidationException, RemoteException, EngineException {
        if (eCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec is null."));
        }
        Immediate immediate = new Immediate();
        immediate.setSpec(ECSpecAdapter.aleToAxis(eCSpec));
        ECReports eCReports = null;
        try {
            e.fine("Invoking ALEService.immediate...");
            eCReports = this.d.immediate(immediate);
            e.fine("Returned from ALEService.immediate.");
        }
        catch (com.connecterra.ale.axis.service.epcglobal.ale.ECSpecValidationException eCSpecValidationException) {
            throw new ECSpecValidationException(eCSpecValidationException.getReason(), eCSpecValidationException);
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        if (eCReports == null) {
            return null;
        }
        try {
            return new ECReportsAdapter(eCReports);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public List listLogicalReaderNames() throws RemoteException, EngineException {
        ArrayOfString arrayOfString;
        try {
            e.fine("Calling ALEService.listLogicalReaderNames...");
            arrayOfString = this.d.listLogicalReaderNames(new EmptyParms());
            e.fine("Returned from ALEService.listLogicalReaderNames.");
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        return SOAPALEClient.c(arrayOfString);
    }

    private static List c(ArrayOfString arrayOfString) {
        if (arrayOfString == null) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(stringArray);
    }

    private static List b(ArrayOfString arrayOfString) throws URISyntaxException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (arrayOfString == null) {
            return arrayList;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            arrayList.add(new URI(string));
        }
        return arrayList;
    }

    public String getStandardVersion() throws RemoteException, EngineException {
        String string;
        try {
            e.fine("Calling ALEService.getStandardVersion...");
            string = this.d.getStandardVersion(new EmptyParms());
            e.fine("Returned from ALEService.getStandardVersion.");
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        return string;
    }

    public String getVendorVersion() throws RemoteException, EngineException {
        String string;
        try {
            e.fine("Calling ALEService.getStandardVersion...");
            string = this.d.getVendorVersion(new EmptyParms());
            e.fine("Returned from ALEService.getStandardVersion.");
        }
        catch (ImplementationException implementationException) {
            throw new EngineException(implementationException.getReason(), implementationException);
        }
        return string;
    }
}

