/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.dynamicconfig.bean;

import com.connecterra.ale.dynamicconfig.api.PluginConfigParameter;
import com.connecterra.ale.dynamicconfig.bean.PluginParameterConstraint;
import com.connecterra.i18n.I18N;
import java.util.regex.Pattern;

public class PluginParameterConstraintRegEx
extends PluginParameterConstraint
implements com.connecterra.ale.dynamicconfig.api.PluginParameterConstraintRegEx {
    private String g = ".*";
    private int h = 1;
    private int f = Integer.MAX_VALUE;

    public String getDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RegularExpression = " + this.getRegEx() + ", minLength = " + this.getMinLength() + ", maxLength = " + this.getMaxLength());
        return stringBuffer.toString();
    }

    public int getMaxLength() {
        return this.f;
    }

    public void setMaxLength(int n) {
        this.f = n;
    }

    public int getMinLength() {
        return this.h;
    }

    public void setMinLength(int n) {
        this.h = n;
    }

    public String getRegEx() {
        return this.g;
    }

    public void setRegEx(String string) {
        this.g = string;
    }

    public void validate(StringBuffer stringBuffer, PluginConfigParameter pluginConfigParameter) {
        String string = pluginConfigParameter.getValue();
        if (string == null) {
            stringBuffer.append(I18N.get("Null value specified for parameter \"{0}\" \n.", pluginConfigParameter.getKeyName()));
        } else {
            if (string.length() > this.getMaxLength()) {
                stringBuffer.append(I18N.get("Parameter with name \"{0}\" and value \"{1}\" has length greater than the allowed maximum of {2}.\n", (Object)pluginConfigParameter.getKeyName(), (Object)pluginConfigParameter.getValue(), this.getMaxLength()));
            } else if (string.length() < this.getMinLength()) {
                stringBuffer.append(I18N.get("parameter with name \"{0}\" and value \"{1}\" has length less than the allowed minimum length of {2}.\n", (Object)pluginConfigParameter.getKeyName(), (Object)pluginConfigParameter.getValue(), this.getMinLength()));
            }
            if (!Pattern.matches(this.getRegEx(), string)) {
                stringBuffer.append(I18N.get("parameter with name \"{0}\" and value \"{1}\", does not match regular expression of \"{2}\".\n", (Object)pluginConfigParameter.getKeyName(), (Object)pluginConfigParameter.getValue(), (Object)this.getRegEx()));
            }
        }
    }

    protected void dump(StringBuffer stringBuffer, String string) {
        super.dump(stringBuffer, string);
        stringBuffer.append(string + "regular expression: " + this.getRegEx() + "\n");
        stringBuffer.append(string + "min length:         " + this.getMinLength() + "\n");
        stringBuffer.append(string + "max length:         " + this.getMaxLength() + "\n");
    }
}

