/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.Barcode;
import com.connecterra.ale.epc.BarcodePattern;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoderBarcode;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;

public class BarcodeScheme
extends Scheme {
    private final int wb = 4;
    private static final int tb = 6;
    private static final int zb = 6;
    private static final int yb = 2;
    private static final int cc = 50;
    private static final int bc = 64;
    private static final int ac = 0;
    private static final int dc = 6;
    private static final int vb = 12;
    private static final int xb = 14;
    private static final int ub = 64;

    protected int getHeaderBitSize() {
        return 6;
    }

    protected BarcodeScheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new Barcode(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new BarcodePattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(128, I18N.get("Connecterra Barcode"), 4, Scheme.BARCODE_128, TDSVersion.TDS_V_1_27);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>();
        arrayList.add(new EPCFieldDescriptor(2, 6, I18N.get("Header"), I18N.get("Barcode Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("Barcode Header constraint"), 4L)));
        arrayList.add(new EPCFieldDescriptor(2, 6, I18N.get("barcode digits"), I18N.get("decimal length of barcode"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("Barcode size constraint"), 0L, (long)Math.pow(2.0, 6.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 50, I18N.get("radix"), I18N.get("radix"), 2, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("radix constraint"), 0L, 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 50, I18N.get("reserved space"), I18N.get("reserved space"), 3, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("reserved constraint"), 0L)));
        arrayList.add(new EPCFieldDescriptor(2, 64, I18N.get("barcode value"), I18N.get("Connecterra Barcode"), 4, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("barcode constraint"), 0L, (long)Math.pow(2.0, 64.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:connecterra:barcode:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoderBarcode> arrayList = new ArrayList<EPCFieldEncoderBarcode>();
        arrayList.add(new EPCFieldEncoderBarcode(0, 4, 2, 1));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        return this.createTagURIEncoder();
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:connecterra:pat:barcode:";
        return new EPCPatternEncoder(this, string, ".", this.getTagURIEncoder().getEncoderFieldList());
    }

    public EPCPatternEncoder createPureIdentityPatternURIEncoder() {
        String string = "urn:connecterra:idpat:barcode:";
        return new EPCPatternEncoder(this, string, ".", this.getPureIdentityURIEncoder().getEncoderFieldList());
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 0, 6));
        arrayList.add(new EPCBinaryFieldEncoder(1, 6, 6));
        arrayList.add(new EPCBinaryFieldEncoder(2, 12, 2));
        arrayList.add(new EPCBinaryFieldEncoder(3, 14, 50));
        arrayList.add(new EPCBinaryFieldEncoder(4, 64, 64));
        return new EPCBinaryEncoder(this, 4, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
    }

    public static interface Encoding {

        public static interface TAG {
            public static final int BARCODE = 0;
        }

        public static interface PURE_IDENTITY {
            public static final int BARCODE = 0;
        }
    }

    public static interface DescriptorField {
        public static final int HEADER = 0;
        public static final int BARCODE_SIZE = 1;
        public static final int RADIX = 2;
        public static final int RESERVED = 3;
        public static final int BARCODE = 4;
    }
}

