/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverterForCageCode96;
import com.connecterra.ale.epc.DOD96;
import com.connecterra.ale.epc.DOD96Pattern;
import com.connecterra.ale.epc.DODScheme;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class DOD96Scheme
extends DODScheme {
    private final int jc = 47;
    private final int ec = 8;
    private final int kc = 4;
    private final int fc = 48;
    private final int ic = 36;
    private final int mc = 32;
    private final int gc = 40;
    private final int hc = 44;
    private final int lc = 92;

    protected DOD96Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new DOD96(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new DOD96Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(96, I18N.get("Department of Defense (DOD-96)"), 47, Scheme.DOD_96, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("DOD-96 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("DOD-96 Header constraint"), 47L)));
        arrayList.add(new EPCFieldDescriptor(2, 4, I18N.get("Filter Value"), I18N.get("DOD-96 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("DOD-96 Filter Value constraint"), 0L, (long)Math.pow(2.0, 4.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(1, 48, I18N.get("CAGE Code or DoDAAC"), I18N.get("DOD-96 bit CAGE Code or DoDAAC"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("DOD-96 CAGE Code or DoDAAC constraint"), "[ 0-9A-HJ-NP-Z]+", 5, 6)));
        arrayList.add(new EPCFieldDescriptor(2, 36, I18N.get("Serial Number"), I18N.get("DOD-96 Serial Number"), 3, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("DOD-96 Serial Number constraint"), 0L, (long)Math.pow(2.0, 36.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:usdod-96:";
        String string2 = ".";
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderString(1, 2, 5, 6));
        arrayList.add(new EPCFieldEncoderNumeric(2, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:usdod:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 5, 6));
        arrayList.add(new EPCFieldEncoderNumeric(1, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:usdod-96:";
        String string2 = ".";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, string2, list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 32, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 40, 4));
        arrayList.add(new EPCBinaryFieldEncoder(2, 44, 48, new BinaryConverterForCageCode96()));
        arrayList.add(new EPCBinaryFieldEncoder(3, 92, 36));
        return new EPCBinaryEncoder(this, 47, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
    }
}

