/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.DODPattern;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCIDPattern;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternFactory;

public class DODIDPattern
extends EPCIDPattern {
    DODIDPattern(EPCPattern ePCPattern) {
        super(ePCPattern);
    }

    public String getTypeString() {
        return "usdod";
    }

    public EPCPattern getEPCPattern(int n, int n2) {
        DODPattern dODPattern = null;
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("Incorrect Filter Value: " + n2);
        }
        try {
            if (n == 64) {
                dODPattern = EPCPatternFactory.getInstance().createDOD64Pattern();
            } else if (n == 96) {
                dODPattern = EPCPatternFactory.getInstance().createDOD96Pattern();
            } else {
                throw new IllegalArgumentException("Incorrect tag length: " + n);
            }
            if (dODPattern != null) {
                dODPattern.assign(this.getEPCPattern());
                dODPattern.getFilter().setValue(n2);
            }
        }
        catch (EPCException ePCException) {
            throw new IllegalStateException(ePCException.getMessage());
        }
        return dODPattern;
    }
}

