/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.Barcode;
import com.connecterra.ale.epc.DOD64;
import com.connecterra.ale.epc.DOD96;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.GIAI64;
import com.connecterra.ale.epc.GIAI96;
import com.connecterra.ale.epc.GID64I;
import com.connecterra.ale.epc.GID96;
import com.connecterra.ale.epc.GRAI64;
import com.connecterra.ale.epc.GRAI96;
import com.connecterra.ale.epc.SGLN64;
import com.connecterra.ale.epc.SGLN96;
import com.connecterra.ale.epc.SGTIN64;
import com.connecterra.ale.epc.SGTIN96;
import com.connecterra.ale.epc.SSCC64;
import com.connecterra.ale.epc.SSCC96;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.StackLight;
import com.connecterra.ale.epc.UnknownScheme;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.util.List;

public class EPCFactory {
    private static EPCFactory b = null;

    public static EPCFactory getInstance() {
        if (b == null) {
            b = new EPCFactory();
        }
        return b;
    }

    public EPC create(long l, long l2) throws EPCException, EPCFieldDecodingException {
        long[] lArray = new long[]{l, l2};
        return this.create(lArray);
    }

    public EPC create(long[] lArray) throws EPCException, EPCFieldDecodingException {
        if (lArray.length < 1 || lArray.length > 2) {
            throw new IllegalArgumentException("EPC size must be between 0 and 128 bits");
        }
        if (lArray.length == 1) {
            lArray = new long[]{0L, lArray[0]};
        }
        EPC ePC = null;
        EPCBinaryEncoder ePCBinaryEncoder = Scheme.getBinaryEncoderForLongArray(lArray);
        try {
            ePC = ePCBinaryEncoder.decode(lArray);
            ePC.validate();
        }
        catch (EPCFieldDecodingException ePCFieldDecodingException) {
            ePC = UnknownScheme.decodeUnknownFromLongArray(lArray);
            ePC.validate();
        }
        catch (EPCException ePCException) {
            ePC = UnknownScheme.decodeUnknownFromLongArray(lArray);
            ePC.validate();
        }
        return ePC;
    }

    public EPC create(URI uRI) throws EPCException, EPCFieldDecodingException {
        EPC ePC = null;
        EPCEncoder ePCEncoder = Scheme.selectEncoder(uRI);
        ePC = ePCEncoder.decode(uRI);
        ePC.validate();
        return ePC;
    }

    public SGTIN64 createSGTIN64(int n, String string, long l, long l2) throws EPCException {
        SGTIN64 sGTIN64 = new SGTIN64(n, string, l, l2);
        sGTIN64.validate();
        return sGTIN64;
    }

    public SGTIN96 createSGTIN96(int n, String string, long l, long l2) throws EPCException {
        SGTIN96 sGTIN96 = new SGTIN96(n, string, l, l2);
        sGTIN96.validate();
        return sGTIN96;
    }

    public SSCC64 createSSCC64(int n, String string, long l) throws EPCException {
        SSCC64 sSCC64 = new SSCC64(n, string, l);
        sSCC64.validate();
        return sSCC64;
    }

    public SSCC96 createSSCC96(int n, String string, long l) throws EPCException {
        SSCC96 sSCC96 = new SSCC96(n, string, l);
        sSCC96.validate();
        return sSCC96;
    }

    public SGLN64 createSGLN64(int n, String string, long l, long l2) throws EPCException {
        SGLN64 sGLN64 = new SGLN64(n, string, l, l2);
        sGLN64.validate();
        return sGLN64;
    }

    public SGLN96 createSGLN96(int n, String string, long l, long l2) throws EPCException {
        SGLN96 sGLN96 = new SGLN96(n, string, l, l2);
        sGLN96.validate();
        return sGLN96;
    }

    public GRAI64 createGRAI64(int n, String string, long l, long l2) throws EPCException {
        GRAI64 gRAI64 = new GRAI64(n, string, l, l2);
        gRAI64.validate();
        return gRAI64;
    }

    public GRAI96 createGRAI96(int n, String string, long l, long l2) throws EPCException {
        GRAI96 gRAI96 = new GRAI96(n, string, l, l2);
        gRAI96.validate();
        return gRAI96;
    }

    public GIAI64 createGIAI64(int n, String string, long l) throws EPCException {
        GIAI64 gIAI64 = new GIAI64(n, string, l);
        gIAI64.validate();
        return gIAI64;
    }

    public GIAI96 createGIAI96(int n, String string, long l) throws EPCException {
        GIAI96 gIAI96 = new GIAI96(n, string, l);
        gIAI96.validate();
        return gIAI96;
    }

    public GID64I createGID64I(long l, long l2, long l3) throws EPCException {
        GID64I gID64I = new GID64I(l, l2, l3);
        gID64I.validate();
        return gID64I;
    }

    public GID96 createGID96(long l, long l2, long l3) throws EPCException {
        GID96 gID96 = new GID96(l, l2, l3);
        gID96.validate();
        return gID96;
    }

    public DOD64 createDOD64(int n, String string, long l) throws EPCException {
        DOD64 dOD64 = new DOD64(n, string, l);
        dOD64.validate();
        return dOD64;
    }

    public DOD96 createDOD96(int n, String string, long l) throws EPCException {
        DOD96 dOD96 = new DOD96(n, string, l);
        dOD96.validate();
        return dOD96;
    }

    public Barcode createBarcode(int n, long l) throws EPCException {
        Barcode barcode = new Barcode(n, l);
        barcode.validate();
        return barcode;
    }

    public StackLight createStackLight(long l) throws EPCException {
        StackLight stackLight = new StackLight("update", l);
        stackLight.validate();
        return stackLight;
    }

    public EPC create(String string, List list) throws EPCException {
        EPC ePC;
        block35: {
            ePC = null;
            try {
                if (string.equals("connecterra-barcode")) {
                    if (list.size() != 2) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    long l = Long.parseLong((String)list.get(1));
                    ePC = this.createBarcode(n, l);
                    break block35;
                }
                if (string.equals("usdod-64")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string2 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    ePC = this.createDOD64(n, string2, l);
                    break block35;
                }
                if (string.equals("usdod-96")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string3 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    ePC = this.createDOD96(n, string3, l);
                    break block35;
                }
                if (string.equals("sgtin-64")) {
                    if (list.size() != 4) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string4 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    long l2 = Long.parseLong((String)list.get(3));
                    ePC = this.createSGTIN64(n, string4, l, l2);
                    break block35;
                }
                if (string.equals("sgtin-96")) {
                    if (list.size() != 4) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string5 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    long l3 = Long.parseLong((String)list.get(3));
                    ePC = this.createSGTIN96(n, string5, l, l3);
                    break block35;
                }
                if (string.equals("sscc-64")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string6 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    ePC = this.createSSCC64(n, string6, l);
                    break block35;
                }
                if (string.equals("sscc-96")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string7 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    ePC = this.createSSCC96(n, string7, l);
                    break block35;
                }
                if (string.equals("sgln-64")) {
                    if (list.size() != 4) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string8 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    long l4 = Long.parseLong((String)list.get(3));
                    ePC = this.createSGLN64(n, string8, l, l4);
                    break block35;
                }
                if (string.equals("sgln-96")) {
                    if (list.size() != 4) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string9 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    long l5 = Long.parseLong((String)list.get(3));
                    ePC = this.createSGLN96(n, string9, l, l5);
                    break block35;
                }
                if (string.equals("grai-64")) {
                    if (list.size() != 4) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string10 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    long l6 = Long.parseLong((String)list.get(3));
                    ePC = this.createGRAI64(n, string10, l, l6);
                    break block35;
                }
                if (string.equals("grai-96")) {
                    if (list.size() != 4) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string11 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    long l7 = Long.parseLong((String)list.get(3));
                    ePC = this.createGRAI96(n, string11, l, l7);
                    break block35;
                }
                if (string.equals("giai-64")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string12 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    ePC = this.createGIAI64(n, string12, l);
                    break block35;
                }
                if (string.equals("giai-96")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    int n = Integer.parseInt((String)list.get(0));
                    String string13 = (String)list.get(1);
                    long l = Long.parseLong((String)list.get(2));
                    ePC = this.createGIAI96(n, string13, l);
                    break block35;
                }
                if (string.equals("gid-64-i")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    long l = Long.parseLong((String)list.get(0));
                    long l8 = Long.parseLong((String)list.get(1));
                    long l9 = Long.parseLong((String)list.get(2));
                    ePC = this.createGID64I(l, l8, l9);
                    break block35;
                }
                if (string.equals("gid-96")) {
                    if (list.size() != 3) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    long l = Long.parseLong((String)list.get(0));
                    long l10 = Long.parseLong((String)list.get(1));
                    long l11 = Long.parseLong((String)list.get(2));
                    ePC = this.createGID96(l, l10, l11);
                    break block35;
                }
                if (string.equals("connecterra-stacklight")) {
                    if (list.size() != 1) {
                        throw new EPCException(I18N.get("wrong number of arguments"));
                    }
                    long l = Long.parseLong((String)list.get(0));
                    ePC = this.createStackLight(l);
                    break block35;
                }
                throw new EPCException(I18N.get("unsupported scheme: {0}", string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new EPCException(I18N.get("error parsing numeric value {0}", numberFormatException.getLocalizedMessage()), numberFormatException);
            }
            catch (ClassCastException classCastException) {
                throw new EPCException(I18N.get("unexpected type found {0}", classCastException.getLocalizedMessage()), classCastException);
            }
        }
        return ePC;
    }
}

