/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.Iterator;

public class EPCImpl {
    private Scheme c;
    private ArrayList b;

    EPCImpl(Scheme scheme) throws EPCException {
        this.c = scheme;
    }

    protected ArrayList getEPCFieldArrayList() throws EPCException {
        if (this.b == null) {
            this.b = this.createFieldList();
        }
        return this.b;
    }

    protected ArrayList createFieldList() throws EPCException {
        ArrayList<EPCField> arrayList = new ArrayList<EPCField>();
        ArrayList arrayList2 = this.getEPCDescriptor().getEPCFieldDescriptorList();
        for (EPCFieldDescriptor ePCFieldDescriptor : arrayList2) {
            if (ePCFieldDescriptor.getType() == 2) {
                arrayList.add(new EPCFieldNumeric(ePCFieldDescriptor));
                continue;
            }
            if (ePCFieldDescriptor.getType() == 1) {
                arrayList.add(new EPCFieldString(ePCFieldDescriptor));
                continue;
            }
            throw new EPCException(I18N.get("unsupported EPCFieldDescriptor type {0}", ePCFieldDescriptor.getClass()));
        }
        return arrayList;
    }

    public EPCField getField(int n) throws EPCException {
        EPCField ePCField = null;
        EPCField ePCField2 = null;
        ArrayList arrayList = this.getEPCFieldArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && ePCField == null) {
            ePCField2 = (EPCField)iterator.next();
            if (ePCField2.getEPCFieldDescriptor().getIndex() != n) continue;
            ePCField = ePCField2;
        }
        return ePCField;
    }

    public EPCDescriptor getEPCDescriptor() {
        return this.c.getEPCDescriptor();
    }
}

