/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCDecodeException;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternFactory;
import com.connecterra.ale.epc.EPCPatternField;
import com.connecterra.ale.epc.EPCPatternFieldNumeric;
import com.connecterra.ale.epc.EPCPatternFieldString;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.EPCPatternValidationException;
import com.connecterra.ale.epc.NonEnumerablePatternException;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;

public abstract class EPCPattern
implements Cloneable {
    private EPCPatternImpl b;

    public static EPCPattern createInstance(URI uRI) throws EPCDecodeException {
        EPCPattern ePCPattern = null;
        try {
            ePCPattern = EPCPatternFactory.getInstance().create(uRI);
        }
        catch (EPCException ePCException) {
            throw new EPCDecodeException(I18N.get("error decoding uri: {0}, {1}", (Object)uRI.toString(), (Object)ePCException.getLocalizedMessage()), ePCException);
        }
        return ePCPattern;
    }

    public static EPCPattern createInstance(String string) throws EPCDecodeException {
        EPCPattern ePCPattern = null;
        try {
            ePCPattern = EPCPatternFactory.getInstance().create(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new EPCDecodeException(I18N.get("error decoding uri string: {0}, {1}", (Object)string, (Object)uRISyntaxException.getLocalizedMessage()), uRISyntaxException);
        }
        catch (EPCException ePCException) {
            throw new EPCDecodeException(I18N.get("error decoding uri string: {0}, {1}", (Object)string, (Object)ePCException.getLocalizedMessage()), ePCException);
        }
        return ePCPattern;
    }

    public static EPCPattern createInstance(EPC ePC) {
        EPCPattern ePCPattern = null;
        if (ePC == null) {
            throw new IllegalArgumentException(I18N.get("Null epc"));
        }
        try {
            EPCPatternImpl ePCPatternImpl = new EPCPatternImpl(ePC.getScheme());
            int n = ePCPatternImpl.getEPCDescriptor().getFieldDescriptorCount();
            for (int i = 0; i < n; ++i) {
                ePCPatternImpl.getPatternField(i).assign(ePC.getEPCField(i));
            }
            ePCPattern = ePC.getScheme().createEPCPattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new IllegalArgumentException(I18N.get("Unrecognized EPC type: {0}", ePC.getScheme().getEPCDescriptor().getDescription()));
        }
        return ePCPattern;
    }

    protected EPCPattern() {
    }

    protected EPCPattern(EPCPatternImpl ePCPatternImpl) {
        this.b = ePCPatternImpl;
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public abstract Scheme getScheme();

    protected final Object clone() {
        EPCPattern ePCPattern = null;
        try {
            EPCPatternImpl ePCPatternImpl = new EPCPatternImpl(this.getScheme());
            int n = ePCPatternImpl.getEPCDescriptor().getFieldDescriptorCount();
            for (int i = 0; i < n; ++i) {
                ePCPatternImpl.getPatternField(i).assign(this.getEPCPatternField(i));
            }
            ePCPattern = this.getScheme().createEPCPattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        if (!this.equals(ePCPattern)) {
            ePCPattern = null;
        }
        return ePCPattern;
    }

    public void validate() throws EPCPatternValidationException, EPCPatternException {
        try {
            this.getScheme().validate(this);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getLocalizedMessage(), ePCException);
        }
    }

    public int getBitSize() {
        return this.getScheme().getEPCDescriptor().getBitSize();
    }

    public int getHeader() {
        return this.getScheme().getEPCDescriptor().getHeader();
    }

    public URI getURI() {
        URI uRI = null;
        try {
            uRI = this.getPatternURI();
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return uRI;
    }

    public URI getPatternURI() throws EPCException {
        return this.getScheme().getPatternEncoder().encode(this);
    }

    public URI getPureIdentityPatternURI() throws EPCException {
        return this.getScheme().getPureIdentityPatternEncoder().encode(this);
    }

    public static TDSVersion getTDSVersion() {
        return EPC.getTDSVersion();
    }

    protected EPCPatternImpl getEPCPatternImpl() throws EPCPatternException, EPCException {
        if (this.b == null) {
            this.b = new EPCPatternImpl(this.getScheme());
        }
        return this.b;
    }

    public EPCPatternField getEPCPatternField(int n) throws EPCException, EPCPatternException, IndexOutOfBoundsException {
        return this.getEPCPatternImpl().getPatternField(n);
    }

    public void setEPCPatternField(int n, EPCPatternField ePCPatternField) throws EPCException, EPCPatternException, IndexOutOfBoundsException {
        EPCPatternField ePCPatternField2 = this.getEPCPatternImpl().getPatternField(n);
        ePCPatternField2.assign(ePCPatternField);
    }

    protected void assign(EPCPattern ePCPattern) throws EPCPatternException, EPCException {
        EPCPatternImpl ePCPatternImpl = this.getEPCPatternImpl();
        int n = ePCPatternImpl.getEPCDescriptor().getFieldDescriptorCount();
        for (int i = 1; i < n; ++i) {
            this.getEPCPatternField(i).assign(ePCPattern.getEPCPatternField(i));
        }
    }

    public String dump() throws EPCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EPC Scheme:        " + this.getScheme().getEPCDescriptor().getDescription() + "\n");
        stringBuffer.append("  EPC Pattern URI:   " + this.getPatternURI().toASCIIString() + "\n");
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "";
        try {
            string = this.getPatternURI().toASCIIString();
        }
        catch (EPCException ePCException) {
            string = ePCException.getMessage();
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof EPCPattern) {
            EPCPattern ePCPattern = (EPCPattern)object;
            if (this.getScheme().equals(ePCPattern.getScheme())) {
                try {
                    int n = this.getEPCPatternImpl().getEPCDescriptor().getFieldDescriptorCount();
                    bl = true;
                    for (int i = 0; bl && i < n; ++i) {
                        bl = this.getEPCPatternField(i).equals(this.getEPCPatternField(i));
                    }
                }
                catch (EPCException ePCException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public boolean matches(EPC ePC) throws EPCException {
        boolean bl = false;
        if (ePC == null) {
            throw new EPCException(I18N.get("EPC is null"));
        }
        if (this.getScheme() == ePC.getScheme()) {
            EPCDescriptor ePCDescriptor = this.getScheme().getEPCDescriptor();
            int n = ePCDescriptor.getFieldDescriptorCount();
            bl = true;
            for (int i = 1; bl && i < n; ++i) {
                EPCPatternField ePCPatternField = this.getEPCPatternField(i);
                EPCField ePCField = ePC.getEPCImpl().getField(i);
                bl = ePCPatternField.match(ePCField);
            }
        }
        return bl;
    }

    public boolean disjoint(EPCPattern ePCPattern) throws EPCException, EPCPatternException {
        boolean bl = false;
        if (ePCPattern == null) {
            throw new EPCPatternException(I18N.get("epcPattern is null"));
        }
        if (this.getScheme() == ePCPattern.getScheme()) {
            EPCDescriptor ePCDescriptor = this.getScheme().getEPCDescriptor();
            int n = ePCDescriptor.getFieldDescriptorCount();
            for (int i = 1; !bl && i < n; ++i) {
                EPCPatternField ePCPatternField = this.getEPCPatternField(i);
                EPCPatternField ePCPatternField2 = ePCPattern.getEPCPatternField(i);
                bl = ePCPatternField.disjoint(ePCPatternField2);
            }
        }
        return bl;
    }

    public final String getGroupNameForEPC(EPC ePC) {
        String string = null;
        try {
            EPCPattern ePCPattern = EPCPattern.createInstance(ePC);
            EPCPatternImpl ePCPatternImpl = this.getEPCPatternImpl();
            int n = ePCPatternImpl.getEPCDescriptor().getFieldDescriptorCount();
            for (int i = 0; i < n; ++i) {
                EPCPatternField ePCPatternField = this.getEPCPatternField(i);
                if (ePCPatternField.isStar()) {
                    ePCPattern.getEPCPatternImpl().getPatternField(i).setStar();
                    continue;
                }
                if (!ePCPatternField.isRange()) continue;
                ePCPattern.getEPCPatternImpl().getPatternField(i).assign(ePCPatternField);
            }
            string = ePCPattern.getPatternURI().toString();
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return string;
    }

    public final String getTypeString() {
        return this.getScheme().getTypeString();
    }

    public boolean canEnumerateEPCs() {
        boolean bl = true;
        try {
            Iterator iterator = this.getEPCPatternImpl().getEPCFieldArrayList().iterator();
            while (bl && iterator.hasNext()) {
                EPCPatternField ePCPatternField = (EPCPatternField)iterator.next();
                if (ePCPatternField.getEPCFieldDescriptor().getType() != 1 || ePCPatternField.isPoint()) continue;
                bl = false;
            }
        }
        catch (EPCPatternException ePCPatternException) {
            bl = false;
        }
        catch (EPCException ePCException) {
            bl = false;
        }
        return bl;
    }

    protected long getEPCCount() {
        long l = 1L;
        try {
            for (EPCPatternField ePCPatternField : this.getEPCPatternImpl().getEPCFieldArrayList()) {
                l *= ePCPatternField.getEPCCount();
            }
        }
        catch (EPCPatternException ePCPatternException) {
            l = 0L;
        }
        catch (EPCException ePCException) {
            l = 0L;
        }
        return l;
    }

    public final boolean containsAny(EPCPattern ePCPattern) throws NonEnumerablePatternException {
        boolean bl = false;
        try {
            bl = !this.disjoint(ePCPattern);
        }
        catch (EPCException ePCException) {
            bl = false;
        }
        return bl;
    }

    public EPC getFirstEPC() throws NonEnumerablePatternException {
        EPC ePC = null;
        if (!this.canEnumerateEPCs()) {
            throw new NonEnumerablePatternException();
        }
        try {
            EPCImpl ePCImpl = new EPCImpl(this.getScheme());
            EPCDescriptor ePCDescriptor = this.getScheme().getEPCDescriptor();
            int n = ePCDescriptor.getFieldDescriptorCount();
            for (int i = 1; i < n; ++i) {
                EPCPatternField ePCPatternField = this.getEPCPatternField(i);
                EPCField ePCField = ePCImpl.getField(i);
                if (ePCField instanceof EPCFieldString) {
                    String string = ((EPCPatternFieldString)ePCPatternField).getValue();
                    ((EPCFieldString)ePCField).setValue(string);
                    continue;
                }
                if (!(ePCField instanceof EPCFieldNumeric)) continue;
                long l = ((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMin().getValue();
                ((EPCFieldNumeric)ePCField).setValue(l);
            }
            ePC = this.getScheme().createEPC(ePCImpl);
            ePC.validate();
        }
        catch (EPCException ePCException) {
            throw new NonEnumerablePatternException(ePCException.getLocalizedMessage(), ePCException);
        }
        return ePC;
    }

    public final EPCPattern intersectWith(EPCPattern ePCPattern) throws NonEnumerablePatternException {
        long l;
        long l2;
        if (ePCPattern == null) {
            return null;
        }
        if (!this.getTypeString().equals(ePCPattern.getTypeString())) {
            return null;
        }
        if (!this.canEnumerateEPCs() || !ePCPattern.canEnumerateEPCs()) {
            throw new NonEnumerablePatternException();
        }
        EPCPattern ePCPattern2 = (EPCPattern)this.clone();
        if (this.hasFilter()) {
            l2 = Math.max(this.getFilterMin(), ePCPattern.getFilterMin());
            if (l2 > (l = Math.min(this.getFilterMax(), ePCPattern.getFilterMax()))) {
                return null;
            }
            ePCPattern2.setFilterRange((int)l2, (int)l);
        }
        if (this.hasDomainManager()) {
            l2 = Math.max(this.getDomainManagerMin(), ePCPattern.getDomainManagerMin());
            if (l2 > (l = Math.min(this.getDomainManagerMax(), ePCPattern.getDomainManagerMax()))) {
                return null;
            }
            ePCPattern2.setDomainManagerRange(l2, l);
        }
        if (this.hasObjectClass()) {
            l2 = Math.max(this.getObjectClassMin(), ePCPattern.getObjectClassMin());
            if (l2 > (l = Math.min(this.getObjectClassMax(), ePCPattern.getObjectClassMax()))) {
                return null;
            }
            ePCPattern2.setObjectClassRange(l2, l);
        }
        if (this.hasSerialNumber()) {
            l2 = Math.max(this.getSerialNumberMin(), ePCPattern.getSerialNumberMin());
            if (l2 > (l = Math.min(this.getSerialNumberMax(), ePCPattern.getSerialNumberMax()))) {
                return null;
            }
            ePCPattern2.setSerialNumberRange(l2, l);
        }
        return ePCPattern2;
    }

    protected boolean hasField(int n) {
        boolean bl = false;
        if (n < this.getScheme().getEPCDescriptor().getFieldDescriptorCount()) {
            try {
                EPCPatternField ePCPatternField = this.getEPCPatternField(n);
                if (ePCPatternField instanceof EPCPatternFieldNumeric || ePCPatternField instanceof EPCPatternFieldString) {
                    bl = true;
                }
            }
            catch (EPCException ePCException) {
                // empty catch block
            }
        }
        return bl;
    }

    protected boolean isFieldX(int n) {
        boolean bl = false;
        if (this.hasField(n)) {
            try {
                EPCPatternField ePCPatternField = this.getEPCPatternField(n);
                bl = ePCPatternField.isX();
            }
            catch (EPCException ePCException) {
                // empty catch block
            }
        }
        return bl;
    }

    protected boolean isFieldStar(int n) {
        boolean bl = false;
        if (this.hasField(n)) {
            try {
                EPCPatternField ePCPatternField = this.getEPCPatternField(n);
                bl = ePCPatternField.isStar();
            }
            catch (EPCException ePCException) {
                // empty catch block
            }
        }
        return bl;
    }

    protected int getFieldLength(int n) {
        int n2 = 0;
        boolean bl = false;
        try {
            EPCFieldString ePCFieldString;
            String string;
            EPCPatternField ePCPatternField = this.getEPCPatternField(n);
            EPCField ePCField = ePCPatternField.getEPCField();
            if (ePCField instanceof EPCFieldNumeric) {
                EPCFieldNumeric ePCFieldNumeric = (EPCFieldNumeric)ePCField;
                n2 = ePCFieldNumeric.getSize();
            } else if (ePCField instanceof EPCFieldString && (string = (ePCFieldString = (EPCFieldString)ePCField).getValue()) != null) {
                n2 = string.length();
            }
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return n2;
    }

    protected long getFieldMin(int n) {
        long l = 0L;
        try {
            String string;
            EPCPatternField ePCPatternField = this.getEPCPatternField(n);
            if (ePCPatternField instanceof EPCPatternFieldNumeric) {
                l = ((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMin().getValue();
            } else if (ePCPatternField instanceof EPCPatternFieldString && (string = ((EPCPatternFieldString)ePCPatternField).getValue()) != null) {
                l = Long.parseLong(string);
            }
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return l;
    }

    protected long getFieldMax(int n) {
        long l = 0L;
        try {
            String string;
            EPCPatternField ePCPatternField = this.getEPCPatternField(n);
            if (ePCPatternField instanceof EPCPatternFieldNumeric) {
                l = ((EPCPatternFieldNumeric)ePCPatternField).getEPCFieldNumericMax().getValue();
            } else if (ePCPatternField instanceof EPCPatternFieldString && (string = ((EPCPatternFieldString)ePCPatternField).getValue()) != null) {
                l = Long.parseLong(string);
            }
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return l;
    }

    protected long setFieldRange(int n, long l, long l2) {
        long l3 = 0L;
        if (this.hasField(n)) {
            try {
                EPCPatternField ePCPatternField = this.getEPCPatternField(n);
                if (ePCPatternField instanceof EPCPatternFieldNumeric) {
                    ((EPCPatternFieldNumeric)ePCPatternField).setRange(l, l2);
                }
            }
            catch (EPCException ePCException) {
                // empty catch block
            }
        }
        return l3;
    }

    public boolean hasFilter() {
        return this.hasField(1);
    }

    public boolean isFilterX() {
        return this.isFieldX(1);
    }

    public boolean isFilterStar() {
        return this.isFieldStar(1);
    }

    public long getFilterMin() {
        return this.getFieldMin(1);
    }

    public long getFilterMax() {
        return this.getFieldMax(1);
    }

    protected void setFilterRange(long l, long l2) {
        this.setFieldRange(1, l, l2);
    }

    public boolean hasDomainManager() {
        return this.hasField(2);
    }

    public int getDomainManagerLength() {
        return this.getFieldLength(2);
    }

    public boolean isDomainManagerX() {
        return this.isFieldX(2);
    }

    public boolean isDomainManagerStar() {
        return this.isFieldStar(2);
    }

    public long getDomainManagerMin() {
        return this.getFieldMin(2);
    }

    public long getDomainManagerMax() {
        return this.getFieldMax(2);
    }

    protected void setDomainManagerRange(long l, long l2) {
        this.setFieldRange(2, l, l2);
    }

    public boolean hasObjectClass() {
        return this.hasField(3);
    }

    public int getObjectClassLength() {
        return this.getFieldLength(3);
    }

    public boolean isObjectClassX() {
        return this.isFieldX(3);
    }

    public boolean isObjectClassStar() {
        return this.isFieldStar(3);
    }

    public long getObjectClassMin() {
        return this.getFieldMin(3);
    }

    public long getObjectClassMax() {
        return this.getFieldMax(3);
    }

    protected void setObjectClassRange(long l, long l2) {
        this.setFieldRange(3, l, l2);
    }

    public boolean hasSerialNumber() {
        return this.hasField(4);
    }

    public boolean isSerialNumberX() {
        return this.isFieldX(4);
    }

    public boolean isSerialNumberStar() {
        return this.isFieldStar(4);
    }

    public long getSerialNumberMin() {
        return this.getFieldMin(4);
    }

    public long getSerialNumberMax() {
        return this.getFieldMax(4);
    }

    protected void setSerialNumberRange(long l, long l2) {
        this.setFieldRange(4, l, l2);
    }

    public static interface PatternListField {
        public static final int HEADER = 0;
        public static final int FILTER = 1;
        public static final int DOMAIN_MANAGER = 2;
        public static final int OBJECT_CLASS = 3;
        public static final int SERIAL_NUMBER = 4;
    }
}

