/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternDecodingException;
import com.connecterra.ale.epc.EPCPatternEncodingException;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternFieldEncoder;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class EPCPatternEncoder {
    private final String d;
    private final String c;
    private final Scheme e;
    private final List b;

    public EPCPatternEncoder(Scheme scheme, String string, String string2, List list) {
        this.e = scheme;
        this.d = string;
        this.c = string2;
        this.b = this.b(list);
    }

    private List b(List list) {
        ArrayList<EPCPatternFieldEncoder> arrayList = new ArrayList<EPCPatternFieldEncoder>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            EPCFieldEncoder ePCFieldEncoder = (EPCFieldEncoder)list.get(i);
            arrayList.add(i, new EPCPatternFieldEncoder(ePCFieldEncoder));
        }
        return arrayList;
    }

    EPCPatternFieldEncoder b(int n) {
        return (EPCPatternFieldEncoder)this.b.get(n);
    }

    public URI encode(EPCPattern ePCPattern) throws EPCPatternEncodingException, EPCPatternException {
        URI uRI = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.d);
            for (int i = 0; i < this.b.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(this.c);
                }
                String string = this.b(i).encode(ePCPattern.getEPCPatternImpl());
                stringBuffer.append(string);
            }
            uRI = new URI(stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new EPCPatternEncodingException(exception.getLocalizedMessage(), exception);
        }
        return uRI;
    }

    protected String getFieldName(int n) {
        EPCPatternFieldEncoder ePCPatternFieldEncoder = (EPCPatternFieldEncoder)this.b.get(n);
        int n2 = ePCPatternFieldEncoder.getDescriptorIndex();
        EPCFieldDescriptor ePCFieldDescriptor = this.e.getEPCDescriptor().getFieldDescriptor(n2);
        return ePCFieldDescriptor.getName();
    }

    public EPCPattern decode(URI uRI) throws EPCException, EPCPatternException, EPCPatternDecodingException, EPCFieldDecodingException {
        EPCPattern ePCPattern = null;
        String string = uRI.toASCIIString();
        if (string.indexOf(this.d) != 0) {
            throw new EPCPatternException(I18N.get("Prefix not found {0}", this.d));
        }
        EPCPatternImpl ePCPatternImpl = new EPCPatternImpl(this.e);
        string = string.substring(this.d.length());
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.b.size(); ++i) {
            if (n == -1) {
                Thread.dumpStack();
                throw new EPCPatternDecodingException(I18N.get("URI does not contain field {0}", this.getFieldName(i)));
            }
            String string2 = null;
            if (i == this.b.size() - 1) {
                string2 = string.substring(n);
            } else {
                n2 = string.substring(n).indexOf(this.c);
                if (n2 == -1) {
                    throw new EPCPatternDecodingException(I18N.get("URI does not contain field {0}", this.getFieldName(i)));
                }
                string2 = string.substring(n, n + n2);
            }
            n += n2 + 1;
            this.b(i).decode(ePCPatternImpl, string2);
        }
        ePCPattern = this.e.createEPCPattern(ePCPatternImpl);
        return ePCPattern;
    }

    public String getPrefix() {
        return this.d;
    }

    public String getDelimiter() {
        return this.c;
    }
}

