/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.GID64I;
import com.connecterra.ale.epc.GID64IPattern;
import com.connecterra.ale.epc.GIDScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class GID64IScheme
extends GIDScheme {
    private final int cb = 1;
    private final int z = 2;
    private final int y = 21;
    private final int db = 17;
    private final int gb = 24;
    private final int eb = 64;
    private final int fb = 66;
    private final int ab = 87;
    private final int bb = 104;

    protected GID64IScheme(String string) {
        super(string);
    }

    protected int getHeaderBitSize() {
        return 2;
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new GID64I(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new GID64IPattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("General Identifier (GID-64-i)"), 1, Scheme.GID_64_I, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(4);
        arrayList.add(new EPCFieldDescriptor(2, 2, I18N.get("Header"), I18N.get("GID-64-i bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("GID-64-i Header constraint"), 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 21, I18N.get("General Manager Number"), I18N.get("GID-64-i bit General Manager Number"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GID-64-i General Manager Number constraint"), 0L, (long)Math.pow(2.0, 21.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 17, I18N.get("Object Class"), I18N.get("GID-64-i Object Class"), 2, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GID-64-i Object Class constraint"), 0L, (long)Math.pow(2.0, 17.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 24, I18N.get("Serial Number"), I18N.get("GID-64-i Serial Number"), 3, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GID-64-i Serial Number constraint"), 0L, (long)Math.pow(2.0, 24.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:gid-64-i:";
        String string2 = ".";
        ArrayList<EPCFieldEncoderNumeric> arrayList = new ArrayList<EPCFieldEncoderNumeric>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderNumeric(1, 2, 10));
        arrayList.add(new EPCFieldEncoderNumeric(2, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:gid:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoderNumeric> arrayList = new ArrayList<EPCFieldEncoderNumeric>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderNumeric(1, 2, 10));
        arrayList.add(new EPCFieldEncoderNumeric(2, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:gid-64-i:";
        String string2 = ".";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, string2, list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 2));
        arrayList.add(new EPCBinaryFieldEncoder(1, 66, 21));
        arrayList.add(new EPCBinaryFieldEncoder(2, 87, 17));
        arrayList.add(new EPCBinaryFieldEncoder(3, 104, 24));
        return new EPCBinaryEncoder(this, 1, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
    }
}

