/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverterForCompanyPrefixIndex;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefix;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.GRAI64;
import com.connecterra.ale.epc.GRAI64Pattern;
import com.connecterra.ale.epc.GRAIScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class GRAI64Scheme
extends GRAIScheme {
    private final int wd = 10;
    private static final int be = 12;
    private final int sd = 8;
    private final int xd = 3;
    private final int ce = 14;
    private final int zd = 20;
    private final int ud = 19;
    private final int ae = 64;
    private final int td = 72;
    private final int vd = 75;
    private final int de = 89;
    private final int yd = 109;

    protected GRAI64Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new GRAI64(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new GRAI64Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("Global Returnable Asset Identifier (GRAI-64)"), 10, Scheme.GRAI_64, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("GRAI-64 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("GRAI-64 Header constraint"), 10L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("GRAI-64 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GRAI-64 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 14, I18N.get("Company Prefix"), I18N.get("GRAI-64 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("GRAI-64 Company Prefix constraint"), "[0-9]+", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 20, I18N.get("Asset Type"), I18N.get("GRAI-64 Asset Type"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GRAI-64 Asset Type constraint"), 0L, (long)Math.pow(2.0, 20.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 19, I18N.get("Serial Number"), I18N.get("GRAI-64 Serial Number"), 4, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GRAI-64 Serial Number constraint"), 0L, (long)Math.pow(2.0, 19.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:grai-64:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 1, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 2, 2, 3, 12));
        arrayList.add(new EPCFieldEncoderNumeric(3, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:grai:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 0, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 1, 2, 3, 12));
        arrayList.add(new EPCFieldEncoderNumeric(2, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:grai-64:";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, ".", list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 72, 3));
        arrayList.add(new EPCBinaryFieldEncoder(2, 75, 14, new BinaryConverterForCompanyPrefixIndex(this)));
        arrayList.add(new EPCBinaryFieldEncoder(3, 89, 20));
        arrayList.add(new EPCBinaryFieldEncoder(4, 109, 19));
        return new EPCBinaryEncoder(this, 10, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        GRAI64 gRAI64 = (GRAI64)ePC;
        String string = gRAI64.getCompanyPrefix();
        long l = gRAI64.getAssetType();
        this.interFieldValidationForGS1_64(12, string, l);
    }
}

