/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryCompanyPrefixAndComplimentFieldEncoder;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder96bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.GRAI96;
import com.connecterra.ale.epc.GRAI96Pattern;
import com.connecterra.ale.epc.GRAIScheme;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class GRAI96Scheme
extends GRAIScheme {
    private final int hd = 51;
    private static int[][] md = new int[][]{{0, 40, 12, 4, 0}, {1, 37, 11, 7, 1}, {2, 34, 10, 10, 2}, {3, 30, 9, 14, 3}, {4, 27, 8, 17, 4}, {5, 24, 7, 20, 5}, {6, 20, 6, 24, 6}};
    private static final PartitionTable qd = new PartitionTable(md);
    private final int pd = 32;
    private final int dd = 8;
    private final int fd = 40;
    private final int jd = 3;
    private final int ed = 43;
    private final int od = 3;
    private final int ld = 46;
    private final int id = 40;
    private final int nd = 24;
    private final int rd = 44;
    private final int kd = 90;
    private final int gd = 38;

    protected GRAI96Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new GRAI96(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new GRAI96Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(96, I18N.get("Global Returnable Asset Identifier (GRAI-96)"), 51, Scheme.GRAI_96, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("GRAI-96 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("GRAI-96 Header constraint"), 51L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("GRAI-96 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GRAI-96 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 40, I18N.get("Company Prefix"), I18N.get("GRAI-96 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("GRAI-96 Company Prefix constraint"), "[0-9]*", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 24, I18N.get("Asset Type"), I18N.get("GRAI-96 Asset Type"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GRAI-96 Asset Type constraint"), 0L, 999999L)));
        arrayList.add(new EPCFieldDescriptor(2, 38, I18N.get("Serial Number"), I18N.get("GRAI-96 Serial Number"), 4, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GRAI-96 Serial Number constraint"), 0L, 0x3FFFFFFFFFL)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:grai-96:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderString(1, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 2, 2, 3, qd));
        arrayList.add(new EPCFieldEncoderNumeric(3, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:grai:";
        String string2 = ".";
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 1, 2, 3, qd));
        arrayList.add(new EPCFieldEncoderNumeric(2, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:grai-96:";
        String string2 = ".";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, string2, list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 32, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 40, 3));
        arrayList.add(new EPCBinaryCompanyPrefixAndComplimentFieldEncoder(2, 3, 43, 3, 44, qd));
        arrayList.add(new EPCBinaryFieldEncoder(4, 90, 38));
        return new EPCBinaryEncoder(this, 51, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        this.interFieldValidationWithPartitionTable(ePC, qd, 2, 3);
    }
}

