/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryCompanyPrefixAndComplimentFieldEncoder;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder96bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.ale.epc.SGTIN96;
import com.connecterra.ale.epc.SGTIN96Pattern;
import com.connecterra.ale.epc.SGTINScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class SGTIN96Scheme
extends SGTINScheme {
    private final int rg = 48;
    private static int[][] vg = new int[][]{{0, 40, 12, 4, 1}, {1, 37, 11, 7, 2}, {2, 34, 10, 10, 3}, {3, 30, 9, 14, 4}, {4, 27, 8, 17, 5}, {5, 24, 7, 20, 6}, {6, 20, 6, 24, 7}};
    private static final PartitionTable yg = new PartitionTable(vg);
    private final int mg = 8;
    private final int tg = 3;
    private final int xg = 3;
    private final int sg = 44;
    private final int qg = 38;
    private final int wg = 32;
    private final int og = 40;
    private final int ng = 43;
    private final int zg = 46;
    private final int ug = 90;
    private final int pg = 128;

    protected SGTIN96Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new SGTIN96(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new SGTIN96Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(96, I18N.get("Serialized Global Trade Item Number (SGTIN-96)"), 48, Scheme.SGTIN_96, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("SGTIN-96 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("SGTIN-96 Header constraint"), 48L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("SGTIN-96 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGTIN-96 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 40, I18N.get("Company Prefix"), I18N.get("SGTIN-96 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("SGTIN-96 Company Prefix constraint"), "[0-9]+", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 24, I18N.get("Item Reference"), I18N.get("SGTIN-96 Item Reference"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGTIN-96 Item Reference constraint"), 0L, 9999999L)));
        arrayList.add(new EPCFieldDescriptor(2, 38, I18N.get("Serial Number"), I18N.get("SGTIN-96 Serial Number"), 4, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGTIN-96 Serial Number constraint"), 0L, 0x3FFFFFFFFFL)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:sgtin-96:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderString(1, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 2, 2, 3, yg));
        arrayList.add(new EPCFieldEncoderNumeric(3, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:sgtin:";
        String string2 = ".";
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 1, 2, 3, yg));
        arrayList.add(new EPCFieldEncoderNumeric(2, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:sgtin-96:";
        String string2 = ".";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, string2, list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 32, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 40, 3));
        arrayList.add(new EPCBinaryCompanyPrefixAndComplimentFieldEncoder(2, 3, 43, 3, 44, yg));
        arrayList.add(new EPCBinaryFieldEncoder(4, 90, 38));
        return new EPCBinaryEncoder(this, 48, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        this.interFieldValidationWithPartitionTable(ePC, yg, 2, 3);
    }
}

