/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCIDPattern;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternFactory;
import com.connecterra.ale.epc.SGTINPattern;

public class SGTINIDPattern
extends EPCIDPattern {
    SGTINIDPattern(EPCPattern ePCPattern) {
        super(ePCPattern);
    }

    public String getTypeString() {
        return "sgtin";
    }

    public EPCPattern getEPCPattern(int n, int n2) {
        SGTINPattern sGTINPattern = null;
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("Incorrect Filter Value: " + n2);
        }
        try {
            if (n == 64) {
                sGTINPattern = EPCPatternFactory.getInstance().createSGTIN64Pattern();
            } else if (n == 96) {
                sGTINPattern = EPCPatternFactory.getInstance().createSGTIN96Pattern();
            } else {
                throw new IllegalArgumentException("Incorrect tag length: " + n);
            }
            if (sGTINPattern != null) {
                sGTINPattern.assign(this.getEPCPattern());
                sGTINPattern.getFilter().setValue(n2);
            }
        }
        catch (EPCException ePCException) {
            throw new IllegalStateException(ePCException.getMessage());
        }
        return sGTINPattern;
    }
}

