/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCIDPattern;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternFactory;
import com.connecterra.ale.epc.SSCCPattern;

public class SSCCIDPattern
extends EPCIDPattern {
    SSCCIDPattern(EPCPattern ePCPattern) {
        super(ePCPattern);
    }

    public String getTypeString() {
        return "sscc";
    }

    public EPCPattern getEPCPattern(int n, int n2) {
        SSCCPattern sSCCPattern = null;
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("Incorrect Filter Value: " + n2);
        }
        try {
            if (n == 64) {
                sSCCPattern = EPCPatternFactory.getInstance().createSSCC64Pattern();
            } else if (n == 96) {
                sSCCPattern = EPCPatternFactory.getInstance().createSSCC96Pattern();
            } else {
                throw new IllegalArgumentException("Incorrect tag length: " + n);
            }
            if (sSCCPattern != null) {
                sSCCPattern.assign(this.getEPCPattern());
                sSCCPattern.getFilter().setValue(n2);
            }
        }
        catch (EPCException ePCException) {
            throw new IllegalStateException(ePCException.getMessage());
        }
        return sSCCPattern;
    }
}

