/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintEnumeration;
import com.connecterra.ale.epc.EPCFieldConstraintEnumerationItemString;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.StackLight;
import com.connecterra.ale.epc.StackLightPattern;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;

public class StackLightScheme
extends Scheme {
    private final int bd = 5;
    private static final int cd = 6;
    private static final int zc = 102;
    private static final int xc = 20;
    private static final int ad = 0;
    private static final int wc = 6;
    private static final int yc = 108;

    protected int getHeaderBitSize() {
        return 6;
    }

    protected StackLightScheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new StackLight(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new StackLightPattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(128, I18N.get("Connecterra Stacklight"), 5, Scheme.STACKLIGHT_128, TDSVersion.TDS_V_1_27);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>();
        arrayList.add(new EPCFieldDescriptor(2, 6, I18N.get("Header"), I18N.get("Stacklight Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("Stacklight Header constraint"), 5L)));
        arrayList.add(new EPCFieldDescriptor(2, 102, I18N.get("reserved space"), I18N.get("reserved space"), 1, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("reserved constraint"), 0L)));
        EPCFieldConstraintEnumerationItemString ePCFieldConstraintEnumerationItemString = new EPCFieldConstraintEnumerationItemString("Update", "update stack light command", "update");
        ArrayList<EPCFieldConstraintEnumerationItemString> arrayList2 = new ArrayList<EPCFieldConstraintEnumerationItemString>();
        arrayList2.add(ePCFieldConstraintEnumerationItemString);
        EPCFieldConstraintEnumeration ePCFieldConstraintEnumeration = new EPCFieldConstraintEnumeration("command enumeration constraint", arrayList2);
        arrayList.add(new EPCFieldDescriptor(1, 102, I18N.get("stacklight command"), I18N.get("stacklight command"), 2, false, ePCDescriptor, ePCFieldConstraintEnumeration));
        arrayList.add(new EPCFieldDescriptor(2, 20, I18N.get("stacklight data"), I18N.get("5 blocks of 4 bits for colors: White, Blue, Green, Amber, Red"), 3, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("StackLight data constraint"), 0L, (long)Math.pow(2.0, 20.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:connecterra:stacklight:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 1, 64));
        arrayList.add(new EPCFieldEncoderNumeric(1, 3, 16));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, "=", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        return this.createTagURIEncoder();
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:connecterra:pat:stacklight:";
        return new EPCPatternEncoder(this, string, "=", this.getTagURIEncoder().getEncoderFieldList());
    }

    public EPCPatternEncoder createPureIdentityPatternURIEncoder() {
        String string = "urn:connecterra:idpat:stacklight:";
        return new EPCPatternEncoder(this, string, "=", this.getPureIdentityURIEncoder().getEncoderFieldList());
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 0, 6));
        arrayList.add(new EPCBinaryFieldEncoder(1, 6, 102));
        arrayList.add(new EPCBinaryFieldEncoder(3, 108, 20));
        return new EPCBinaryEncoder(this, 5, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
    }

    public static interface Encoding {

        public static interface TAG {
            public static final int STACKLIGHT_COMMAND = 0;
            public static final int STACKLIGHT_DATA = 1;
        }

        public static interface PURE_IDENTITY {
            public static final int STACKLIGHT_COMMAND = 0;
            public static final int STACKLIGHT_DATA = 1;
        }
    }

    public static interface DescriptorField {
        public static final int HEADER = 0;
        public static final int RESERVED = 1;
        public static final int STACKLIGHT_COMMAND = 2;
        public static final int STACKLIGHT_DATA = 3;
    }
}

