/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc.test;

import com.connecterra.ale.epc.DOD64Pattern;
import com.connecterra.ale.epc.DOD96;
import com.connecterra.ale.epc.DOD96Pattern;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCDecodeException;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFactory;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCIDPattern;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternFactory;
import com.connecterra.ale.epc.GIAI64Pattern;
import com.connecterra.ale.epc.GIAI96Pattern;
import com.connecterra.ale.epc.GID64IPattern;
import com.connecterra.ale.epc.GID96Pattern;
import com.connecterra.ale.epc.GRAI64Pattern;
import com.connecterra.ale.epc.GRAI96Pattern;
import com.connecterra.ale.epc.NumberUtil;
import com.connecterra.ale.epc.SGLN64Pattern;
import com.connecterra.ale.epc.SGLN96Pattern;
import com.connecterra.ale.epc.SGTIN64;
import com.connecterra.ale.epc.SGTIN64Pattern;
import com.connecterra.ale.epc.SGTIN64Scheme;
import com.connecterra.ale.epc.SGTIN96Pattern;
import com.connecterra.ale.epc.SSCC64;
import com.connecterra.ale.epc.SSCC64Pattern;
import com.connecterra.ale.epc.SSCC96Pattern;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.UnknownScheme;
import com.connecterra.ale.epchelpers.EPCIndexTableLoader;
import com.connecterra.util.MultiException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public class ALEEPCTestDriver {
    public static void main(String[] stringArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>(1);
        try {
            arrayList.add(new URL("http://www.onsepc.com/ManagerTranslation.xml"));
            arrayList.add(new URL("file:ManagerTranslation.xml"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        try {
            EPCIndexTableLoader.loadFromURLs(arrayList);
        }
        catch (MultiException multiException) {
            multiException.printStackTrace();
        }
        ALEEPCTestDriver aLEEPCTestDriver = new ALEEPCTestDriver();
        try {
            Object object;
            try {
                object = EPCPatternFactory.getInstance().create(new URI("urn:epc:pat:sgtin-64:X.0037000.[0000011-000009].99"));
            }
            catch (EPCException ePCException) {
                System.out.println("caught expected exception: " + ePCException.getMessage());
            }
            object = EPCFactory.getInstance().create(new URI("urn:connecterra:stacklight:update=3039"));
            System.out.println("Stacklight1 \n" + ((EPC)object).dump());
            EPC ePC = EPCFactory.getInstance().create(((EPC)object).getTagURI());
            System.out.println("Stacklight2 \n" + ePC.dump());
            System.out.println("stacklights are equal " + ((EPC)object).equals(ePC));
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (EPCException ePCException) {
            ePCException.printStackTrace();
        }
        aLEEPCTestDriver.processTestFile("X:\\sw\\workspaces\\egieseke\\rfta\\ALEEPC\\test\\epc2test\\EPCTestCasesShort.csv");
        aLEEPCTestDriver.gencoTest();
        aLEEPCTestDriver.testGetEPCScheme();
        aLEEPCTestDriver.testEPCPatterns();
    }

    protected boolean conversionChain(EPC ePC) throws EPCException, EPCFieldDecodingException {
        boolean bl = false;
        EPCFactory ePCFactory = EPCFactory.getInstance();
        long[] lArray = ePC.getLongArray();
        EPC ePC2 = ePCFactory.create(lArray);
        URI uRI = ePC2.getTagURI();
        EPC ePC3 = ePCFactory.create(uRI);
        URI uRI2 = ePC3.getRawHexURI();
        EPC ePC4 = ePCFactory.create(uRI2);
        URI uRI3 = ePC4.getRawDecimalURI();
        EPC ePC5 = ePCFactory.create(uRI3);
        URI uRI4 = ePC5.getRawHexURI();
        EPC ePC6 = ePCFactory.create(uRI4);
        URI uRI5 = ePC6.getTagURI();
        EPC ePC7 = ePCFactory.create(uRI4);
        long[] lArray2 = ePC7.getLongArray();
        long l = lArray2[0];
        long l2 = 0L;
        if (lArray2.length > 1) {
            l2 = lArray2[1];
        }
        EPC ePC8 = ePCFactory.create(l, l2);
        return ePC.equals(ePC2) && ePC.equals(ePC3) && ePC.equals(ePC4) && ePC.equals(ePC5) && ePC.equals(ePC6) && ePC.equals(ePC7) && ePC.equals(ePC8);
    }

    protected void testConversion(EPC ePC) throws EPCException, EPCFieldDecodingException {
        HashSet<EPC> hashSet = new HashSet<EPC>();
        hashSet.add(ePC);
        boolean bl = false;
        EPCFactory ePCFactory = EPCFactory.getInstance();
        String string = ePC.dump();
        EPC ePC2 = ePCFactory.create(ePC.getLongArray());
        String string2 = ePC2.dump();
        if (!ePC.equals(ePC2)) {
            throw new EPCException("create with long different\n" + ePC.dump() + " " + ePC2.dump());
        }
        hashSet.add(ePC2);
        EPC ePC3 = ePCFactory.create(ePC.getTagURI());
        if (!ePC.equals(ePC3)) {
            throw new EPCException("create with getTagURI() different\n" + ePC.dump() + " " + ePC3.dump());
        }
        hashSet.add(ePC3);
        EPC ePC4 = ePCFactory.create(ePC.getRawHexURI());
        if (!ePC.equals(ePC4)) {
            throw new EPCException("create with getRawHexURI() different\n" + ePC.dump() + " " + ePC4.dump());
        }
        hashSet.add(ePC4);
        EPC ePC5 = ePCFactory.create(ePC.getRawDecimalURI());
        if (!ePC.equals(ePC5)) {
            throw new EPCException("create with getRawDecimalURI() different\n" + ePC.dump() + " " + ePC5.dump());
        }
        hashSet.add(ePC5);
        EPC ePC6 = ePCFactory.create(ePC.getHiValue(), ePC.getLowValue());
        if (!ePC.equals(ePC6)) {
            throw new EPCException("create with getHiValue(), getLowValue() different\n" + ePC.dump() + ePC6.dump());
        }
        hashSet.add(ePC6);
        if (hashSet.size() != 1) {
            throw new EPCException("adding multiple instances to the same set is not working for epc " + ePC.getTagURI());
        }
    }

    protected void epcSmokeTest(String string, EPC ePC) throws URISyntaxException, EPCException, EPCFieldDecodingException {
        EPCPattern ePCPattern = EPCPattern.createInstance(ePC);
        if (!ePCPattern.matches(ePC)) {
            System.out.println("ERROR, epcPattern created from EPC should match that EPC");
        }
        URI uRI = new URI(string);
        System.out.println("testConversion: " + ePC.dump());
        this.testConversion(ePC);
        EPC ePC2 = EPCFactory.getInstance().create(uRI);
        this.testConversion(ePC2);
        if (!ePC.equals(ePC2)) {
            System.err.println("ERROR: epc should be equal, but is not: " + ePC.dump());
            ePC.equals(ePC2);
        }
        System.out.println("testConversion of epc_a: " + ePC2.dump());
        this.testConversion(ePC2);
        System.out.println("testpipe result epc_a: " + this.conversionChain(ePC2));
        System.out.println("Equals: " + ePC.equals(ePC2));
        System.out.println("testpipe result: " + this.conversionChain(ePC));
        System.out.println("-----------------------------------");
    }

    public void comparePatternURIs(URI uRI, URI uRI2) {
        String string;
        String string2 = uRI.toString();
        if (!string2.equals(string = uRI2.toString())) {
            System.err.println("ERROR: pattern URIs do not match!");
            System.err.println("pattern 1: " + string2);
            System.err.println("pattern 2: " + string);
        }
    }

    public void patternURIDecodeEncode(EPCPattern ePCPattern) throws EPCException, EPCFieldDecodingException {
        URI uRI = ePCPattern.getPatternURI();
        System.out.println("pattern uri: " + uRI.toString());
        EPCPattern ePCPattern2 = EPCPatternFactory.getInstance().create(ePCPattern.getPatternURI());
        System.out.println("converted pattern uri: " + ePCPattern2.getPatternURI().toString());
        this.compareEPCPatterns(ePCPattern, ePCPattern2);
    }

    public void compareEPCPatterns(EPCPattern ePCPattern, EPCPattern ePCPattern2) throws EPCException {
        this.comparePatternURIs(ePCPattern.getPatternURI(), ePCPattern2.getPatternURI());
    }

    public void epcPatternSmokeTest(String string, EPCPattern ePCPattern) throws EPCException, EPCFieldDecodingException, URISyntaxException {
        System.out.println("");
        EPCPattern ePCPattern2 = EPCPatternFactory.getInstance().create(new URI(string));
        this.compareEPCPatterns(ePCPattern2, ePCPattern);
        this.comparePatternURIs(ePCPattern2.getPureIdentityPatternURI(), ePCPattern.getPureIdentityPatternURI());
        EPCPattern ePCPattern3 = EPCPatternFactory.getInstance().create(ePCPattern2.getPureIdentityPatternURI());
        this.comparePatternURIs(ePCPattern3.getPureIdentityPatternURI(), ePCPattern2.getPureIdentityPatternURI());
        System.out.println("Pure identity Pattern URI: " + ePCPattern3.getPureIdentityPatternURI());
        System.out.println("Pattern URI:               " + ePCPattern3.getPatternURI());
        System.out.println("Original Pattern URI:      " + ePCPattern2.getPatternURI());
        try {
            EPCIDPattern ePCIDPattern = EPCIDPattern.createInstance(ePCPattern3.getPureIdentityPatternURI().toString());
            System.out.println("idPattern.getDomainManagerMax(): " + ePCIDPattern.getDomainManagerMax());
            System.out.println("idPattern.getDomainManagerMin(): " + ePCIDPattern.getDomainManagerMin());
            System.out.println("idPattern.getDomainManagerLength(): " + ePCIDPattern.getDomainManagerLength());
            System.out.println("idPattern.getObjectClassMax(): " + ePCIDPattern.getObjectClassMax());
            System.out.println("idPattern.getObjectClassMin(): " + ePCIDPattern.getObjectClassMin());
            System.out.println("idPattern.getSerialNumberMax(): " + ePCIDPattern.getSerialNumberMax());
            System.out.println("idPattern.getSerialNumberMin(): " + ePCIDPattern.getSerialNumberMin());
        }
        catch (EPCDecodeException ePCDecodeException) {
            System.err.println(ePCDecodeException.getMessage());
        }
        this.patternURIDecodeEncode(ePCPattern2);
        this.patternURIDecodeEncode(ePCPattern);
    }

    public void testEPCPatterns() {
        try {
            SGTIN64Pattern sGTIN64Pattern = EPCPatternFactory.getInstance().createSGTIN64Pattern();
            sGTIN64Pattern.getFilter().setX();
            sGTIN64Pattern.getCompanyPrefix().setValue("0037000");
            sGTIN64Pattern.getItemReference().setRange(9L, 11L);
            sGTIN64Pattern.getSerialNumber().setValue(99L);
            this.epcPatternSmokeTest("urn:epc:pat:sgtin-64:X.0037000.[000009-000011].99", sGTIN64Pattern);
            SGTIN96Pattern sGTIN96Pattern = EPCPatternFactory.getInstance().createSGTIN96Pattern();
            sGTIN96Pattern.getFilter().setX();
            sGTIN96Pattern.getCompanyPrefix().setValue("0037000");
            sGTIN96Pattern.getItemReference().setRange(9L, 11L);
            sGTIN96Pattern.getSerialNumber().setValue(99L);
            this.epcPatternSmokeTest("urn:epc:pat:sgtin-96:X.0037000.[000009-000011].99", sGTIN96Pattern);
            SSCC64Pattern sSCC64Pattern = EPCPatternFactory.getInstance().createSSCC64Pattern();
            sSCC64Pattern.getFilter().setX();
            sSCC64Pattern.getCompanyPrefix().setValue("0037000");
            sSCC64Pattern.getSerialReference().setRange(9000000L, 11000000L);
            this.epcPatternSmokeTest("urn:epc:pat:sscc-64:X.0037000.[0009000000-0011000000]", sSCC64Pattern);
            SSCC96Pattern sSCC96Pattern = EPCPatternFactory.getInstance().createSSCC96Pattern();
            sSCC96Pattern.getFilter().setX();
            sSCC96Pattern.getCompanyPrefix().setValue("0037000");
            sSCC96Pattern.getSerialReference().setRange(9000000L, 11000000L);
            this.epcPatternSmokeTest("urn:epc:pat:sscc-96:X.0037000.[0009000000-0011000000]", sSCC96Pattern);
            SGLN64Pattern sGLN64Pattern = EPCPatternFactory.getInstance().createSGLN64Pattern();
            sGLN64Pattern.getFilter().setX();
            sGLN64Pattern.getCompanyPrefix().setValue("0037000");
            sGLN64Pattern.getLocationReference().setRange(900L, 1000L);
            sGLN64Pattern.getSerialNumber().setRange(90L, 110L);
            this.epcPatternSmokeTest("urn:epc:pat:sgln-64:X.0037000.[00900-01000].[90-110]", sGLN64Pattern);
            SGLN96Pattern sGLN96Pattern = EPCPatternFactory.getInstance().createSGLN96Pattern();
            sGLN96Pattern.getFilter().setX();
            sGLN96Pattern.getCompanyPrefix().setValue("0037000");
            sGLN96Pattern.getLocationReference().setRange(900L, 1000L);
            sGLN96Pattern.getSerialNumber().setRange(9L, 10L);
            this.epcPatternSmokeTest("urn:epc:pat:sgln-96:X.0037000.[00900-01000].[9-10]", sGLN96Pattern);
            GRAI64Pattern gRAI64Pattern = EPCPatternFactory.getInstance().createGRAI64Pattern();
            gRAI64Pattern.getFilter().setX();
            gRAI64Pattern.getCompanyPrefix().setValue("0037000");
            gRAI64Pattern.getAssetType().setRange(90L, 110L);
            gRAI64Pattern.getSerialNumber().setStar();
            this.epcPatternSmokeTest("urn:epc:pat:grai-64:X.0037000.[00090-00110].*", gRAI64Pattern);
            GRAI96Pattern gRAI96Pattern = EPCPatternFactory.getInstance().createGRAI96Pattern();
            gRAI96Pattern.getFilter().setX();
            gRAI96Pattern.getCompanyPrefix().setValue("0037000");
            gRAI96Pattern.getAssetType().setRange(90L, 110L);
            gRAI96Pattern.getSerialNumber().setStar();
            this.epcPatternSmokeTest("urn:epc:pat:grai-96:X.0037000.[00090-00110].*", gRAI96Pattern);
            GIAI64Pattern gIAI64Pattern = EPCPatternFactory.getInstance().createGIAI64Pattern();
            gIAI64Pattern.getFilter().setX();
            gIAI64Pattern.getCompanyPrefix().setValue("0037000");
            gIAI64Pattern.getIndividualAssetReference().setRange(1L, 800000L);
            this.epcPatternSmokeTest("urn:epc:pat:giai-64:X.0037000.[1-800000]", gIAI64Pattern);
            GIAI96Pattern gIAI96Pattern = EPCPatternFactory.getInstance().createGIAI96Pattern();
            gIAI96Pattern.getFilter().setValue(3L);
            gIAI96Pattern.getCompanyPrefix().setValue("0037000");
            gIAI96Pattern.getIndividualAssetReference().setRange(0x3FFFFFFFFFEL, 0x3FFFFFFFFFFFFFFFL);
            this.epcPatternSmokeTest("urn:epc:pat:giai-96:3.0037000.[4398046511102-4611686018427387903]", gIAI96Pattern);
            GID64IPattern gID64IPattern = EPCPatternFactory.getInstance().createGID64IPattern();
            gID64IPattern.getGeneralManagerNumber().setX();
            gID64IPattern.getObjectClass().setValue(8900L);
            gID64IPattern.getSerialNumber().setRange(1L, 800000L);
            this.epcPatternSmokeTest("urn:epc:pat:gid-64-i:X.8900.[1-800000]", gID64IPattern);
            GID96Pattern gID96Pattern = EPCPatternFactory.getInstance().createGID96Pattern();
            gID96Pattern.getGeneralManagerNumber().setX();
            gID96Pattern.getObjectClass().setValue(8191L);
            gID96Pattern.getSerialNumber().setRange(1L, 800000L);
            this.epcPatternSmokeTest("urn:epc:pat:gid-96:X.8191.[1-800000]", gID96Pattern);
            DOD64Pattern dOD64Pattern = EPCPatternFactory.getInstance().createDOD64Pattern();
            dOD64Pattern.getFilter().setValue(3L);
            dOD64Pattern.getCageCode().setValue("ABCD");
            dOD64Pattern.getSerialNumber().setRange(1L, 800000L);
            this.epcPatternSmokeTest("urn:epc:pat:usdod-64:3.ABCD.[1-800000]", dOD64Pattern);
            DOD96Pattern dOD96Pattern = EPCPatternFactory.getInstance().createDOD96Pattern();
            dOD96Pattern.getFilter().setValue(3L);
            dOD96Pattern.getCageCode().setValue("12ABC");
            dOD96Pattern.getSerialNumber().setRange(1L, 800000L);
            this.epcPatternSmokeTest("urn:epc:pat:usdod-96:3.12ABC.[1-800000]", dOD96Pattern);
            DOD96 dOD96 = EPCFactory.getInstance().createDOD96(3, "12ABC", 800000L);
            System.out.println("match: true = " + dOD96Pattern.matches(dOD96));
            DOD96 dOD962 = EPCFactory.getInstance().createDOD96(2, "12ABC", 800000L);
            System.out.println("match: false = " + dOD96Pattern.matches(dOD962));
            EPCPattern ePCPattern = EPCPatternFactory.getInstance().create(new URI("urn:epc:pat:usdod-96:3.12ABC.[1-800000]"));
            System.out.println("disjoint: false = " + dOD96Pattern.disjoint(ePCPattern));
            EPCPattern ePCPattern2 = EPCPatternFactory.getInstance().create(new URI("urn:epc:pat:usdod-96:4.12ABC.[1-800000]"));
            System.out.println("disjoint: ture = " + dOD96Pattern.disjoint(ePCPattern2));
        }
        catch (EPCException ePCException) {
            System.err.println(ePCException.getMessage());
            ePCException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println(uRISyntaxException.getMessage());
            uRISyntaxException.printStackTrace();
        }
    }

    public void processTestFile(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                boolean bl = this.processInputLine(string2);
                if (bl) continue;
                this.processInputLine(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("ERROR: " + iOException.getMessage());
        }
    }

    public boolean processInputLine(String string) {
        boolean bl = true;
        String string2 = string;
        int n = string2.indexOf(44);
        if (n == -1) {
            return bl;
        }
        String string3 = string2.substring(0, n);
        string2 = string2.substring(n + 1);
        n = string2.indexOf(44);
        String string4 = string2.substring(0, n);
        string2 = string2.substring(n + 1);
        n = string2.indexOf(44);
        String string5 = string2.substring(0, n);
        String string6 = string2.substring(n + 1);
        int n2 = 10;
        EPC ePC = null;
        EPC ePC2 = null;
        if (string3 != null && !string5.equalsIgnoreCase("na")) {
            if (string3.startsWith("x") || string3.startsWith("X")) {
                string3 = string3.substring(1);
                n2 = 16;
            }
            long[] lArray = new long[2];
            BigInteger bigInteger = new BigInteger(string3, n2);
            lArray[0] = NumberUtil.MASK_64.shiftRight(32).and(bigInteger.shiftRight(64)).longValue();
            lArray[1] = NumberUtil.MASK_64.and(bigInteger).longValue();
            boolean bl2 = false;
            try {
                ePC = EPCFactory.getInstance().create(lArray[0], lArray[1]);
            }
            catch (Exception exception) {
                if (string5.equalsIgnoreCase("error")) {
                    System.err.println("failed to create unknown: " + exception.getMessage());
                    bl = false;
                } else {
                    bl = false;
                    System.err.println("ERROR processing binary value: " + exception.getMessage());
                    System.err.println("processing line: " + string);
                }
                bl2 = true;
            }
            if (string5.equalsIgnoreCase("error") && !bl2) {
                if (ePC.getScheme() instanceof UnknownScheme) {
                    try {
                        System.out.println("unknown epc \n" + ePC.dump());
                    }
                    catch (EPCException ePCException) {
                        System.err.println("error dumping unknown type " + ePCException.getMessage());
                        bl = false;
                    }
                } else {
                    try {
                        System.err.println("should have created a unknown type but got this: " + ePC.dump());
                    }
                    catch (EPCException ePCException) {
                        System.err.println("error dumping unknown type " + ePCException.getMessage());
                        bl = false;
                    }
                }
            }
        }
        if (string6 != null && !string6.equalsIgnoreCase("na")) {
            boolean bl3;
            block23: {
                bl3 = false;
                try {
                    ePC2 = EPCFactory.getInstance().create(new URI(string4));
                }
                catch (Exception exception) {
                    bl3 = true;
                    if (string6.equalsIgnoreCase("error")) break block23;
                    bl = false;
                    System.err.println("ERROR processing uri : " + exception.getMessage());
                    System.err.println("processing line: " + string);
                }
            }
            if (string6.equalsIgnoreCase("error") && !bl3) {
                bl = false;
                System.err.println("ERROR, did not generate expected uri error");
                System.err.println("processing line: " + string);
            }
        }
        if (string5.equalsIgnoreCase("ok") && string6.equalsIgnoreCase("ok")) {
            try {
                if (!ePC.getTagURI().toString().equals(ePC2.getTagURI().toString())) {
                    bl = false;
                    System.err.println("binary and uri epcs do not match!");
                }
                if (!ePC.dump().equals(ePC2.dump())) {
                    bl = false;
                    System.err.println("ERROR, binary epc and uri epc do not match");
                    System.err.println("processing line: " + string);
                    System.err.println("BINARY: \n" + ePC.dump());
                    System.err.println("URI: \n" + ePC2.dump());
                }
            }
            catch (Exception exception) {
                bl = false;
                System.err.println("Exception received comparing binary and URI EPCs");
                System.err.println("processing line: " + string);
                System.err.println(exception.getMessage());
            }
        }
        return bl;
    }

    public void gencoTest() {
        try {
            String string = "urn:epc:raw:96.x3114045FB83B9ACA04000000";
            String string2 = "urn:epc:raw:96.x3114045FB83B9ACA04000000";
            System.out.println("uri1: " + string);
            EPC ePC = EPCFactory.getInstance().create(new URI(string));
            System.out.println("gencoEPC1: " + ePC.dump());
            EPC ePC2 = EPCFactory.getInstance().create(new URI(string2));
            System.out.println("gencoEPC2: " + ePC2.dump());
        }
        catch (Exception exception) {
            System.err.println("ERROR: " + exception.getMessage());
        }
    }

    public void testGetEPCScheme() {
        SGTIN64Scheme sGTIN64Scheme = Scheme.SGTIN_64;
        System.out.println("SGTIN64Scheme: " + sGTIN64Scheme + "\n");
        sGTIN64Scheme.getEPCDescriptor();
        try {
            this.epcSmokeTest("urn:connecterra:barcode:0777", EPCFactory.getInstance().createBarcode(4, 777L));
            this.epcSmokeTest("urn:epc:tag:sscc-64:4.0037000.1111111111", EPCFactory.getInstance().createSSCC64(4, "0037000", 1111111111L));
            SSCC64 sSCC64 = EPCFactory.getInstance().createSSCC64(4, "0037000", 1111111111L);
            EPCFieldConstraintMinMax ePCFieldConstraintMinMax = (EPCFieldConstraintMinMax)Scheme.SSCC_64.getEPCDescriptor().getFieldDescriptor(3).getEPCFieldConstraint();
            System.out.println(ePCFieldConstraintMinMax.getMaximumValue());
            System.out.println(ePCFieldConstraintMinMax.getMinimumValue());
            this.epcSmokeTest("urn:epc:tag:sgtin-64:6.0037000.000009.99", EPCFactory.getInstance().createSGTIN64(6, "0037000", 9L, 99L));
            this.epcSmokeTest("urn:epc:tag:sgtin-64:0.0047400.126279.0", EPCFactory.getInstance().createSGTIN64(0, "0047400", 126279L, 0L));
            this.epcSmokeTest("urn:epc:tag:sgtin-64:3.0037000.030241.1041970", EPCFactory.getInstance().createSGTIN64(3, "0037000", 30241L, 1041970L));
            this.epcSmokeTest("urn:epc:tag:sscc-96:0.0037000.0012345678", EPCFactory.getInstance().createSSCC96(0, "0037000", 12345678L));
            this.epcSmokeTest("urn:epc:tag:sscc-64:3.0037000.0012345678", EPCFactory.getInstance().createSSCC64(3, "0037000", 12345678L));
            this.epcSmokeTest("urn:epc:tag:sgtin-64:3.0037000.000400.12345678", EPCFactory.getInstance().createSGTIN64(3, "0037000", 400L, 12345678L));
            this.epcSmokeTest("urn:epc:tag:sgtin-96:3.0037000.000400.12345678", EPCFactory.getInstance().createSGTIN96(3, "0037000", 400L, 12345678L));
            this.epcSmokeTest("urn:epc:tag:sgln-64:3.0037000.00400.12345", EPCFactory.getInstance().createSGLN64(3, "0037000", 400L, 12345L));
            this.epcSmokeTest("urn:epc:tag:sgln-64:3.0047400.00403.45678", EPCFactory.getInstance().createSGLN64(3, "0047400", 403L, 45678L));
            this.epcSmokeTest("urn:epc:tag:sgln-96:3.0037000.00400.12345", EPCFactory.getInstance().createSGLN96(3, "0037000", 400L, 12345L));
            this.epcSmokeTest("urn:epc:tag:sgln-96:3.0850583001.10.12345", EPCFactory.getInstance().createSGLN96(3, "0850583001", 10L, 12345L));
            this.epcSmokeTest("urn:epc:tag:grai-64:3.0850583001.10.12345", EPCFactory.getInstance().createGRAI64(3, "0850583001", 10L, 12345L));
            this.epcSmokeTest("urn:epc:tag:grai-64:3.0037000.00010.12345", EPCFactory.getInstance().createGRAI64(3, "0037000", 10L, 12345L));
            this.epcSmokeTest("urn:epc:tag:grai-96:3.0850583001.10.12345", EPCFactory.getInstance().createGRAI96(3, "0850583001", 10L, 12345L));
            this.epcSmokeTest("urn:epc:tag:grai-96:3.0037000.00010.12345", EPCFactory.getInstance().createGRAI96(3, "0037000", 10L, 12345L));
            this.epcSmokeTest("urn:epc:tag:giai-64:3.0037000.00000000010000000", EPCFactory.getInstance().createGIAI64(3, "0037000", 1L));
            this.epcSmokeTest("urn:epc:tag:giai-96:3.0037000.4398046511103", EPCFactory.getInstance().createGIAI96(3, "0037000", 0x3FFFFFFFFFFL));
            this.epcSmokeTest("urn:epc:tag:gid-64-i:10.20.2", EPCFactory.getInstance().createGID64I(10L, 20L, 2L));
            this.epcSmokeTest("urn:epc:tag:gid-96:10.20.2", EPCFactory.getInstance().createGID96(10L, 20L, 2L));
            this.epcSmokeTest("urn:epc:tag:usdod-96:3.12ABC.800000", EPCFactory.getInstance().createDOD96(3, "12ABC", 800000L));
            this.epcSmokeTest("urn:epc:tag:usdod-96:3.1ABC.800000", EPCFactory.getInstance().createDOD96(3, "1ABC", 800000L));
            URI uRI = new URI("urn:epc:tag:usdod-64:3.1ABC.800000");
            EPC ePC = EPCFactory.getInstance().create(uRI);
            System.out.println(ePC.dump());
            EPC ePC2 = EPCFactory.getInstance().create(ePC.getRawHexURI());
            System.out.println(ePC2.dump());
            this.epcSmokeTest("urn:epc:tag:usdod-64:3.1ABC.800000", EPCFactory.getInstance().createDOD64(3, "1ABC", 800000L));
            URI uRI2 = new URI("urn:epc:tag:sscc-64:3.0037000.0012345678");
            URI uRI3 = new URI("urn:epc:tag:sgtin-64:3.0037000.000400.12345678");
            SSCC64 sSCC642 = EPCFactory.getInstance().createSSCC64(3, "0037000", 12345678L);
            System.out.println("testConversion of sscc64: " + sSCC642.dump());
            this.testConversion(sSCC642);
            EPC ePC3 = EPCFactory.getInstance().create(uRI2);
            this.testConversion(ePC3);
            System.out.println("testConversion of sscc64: " + ePC3.dump());
            this.testConversion(ePC3);
            System.out.println("testpipe result sscc64: " + this.conversionChain(ePC3));
            System.out.println("SSCC64 Equals: " + sSCC642.equals(ePC3));
            System.out.println("testpipe result sscc64: " + this.conversionChain(sSCC642));
            SGTIN64 sGTIN64 = EPCFactory.getInstance().createSGTIN64(3, "0037000", 400L, 12345678L);
            EPC ePC4 = EPCFactory.getInstance().create(uRI3);
            this.testConversion(ePC4);
            System.out.println("sgtin matches: " + sGTIN64.equals(ePC4));
            URI uRI4 = new URI("urn:epc:tag:sgtin-96:0.0037000.800000.1");
            EPC ePC5 = EPCFactory.getInstance().create(uRI4);
            System.out.println("SGTIN-96 " + uRI4.toASCIIString() + "\n" + ePC5.dump());
            System.out.println("testConversion of sgtin96: ");
            this.testConversion(ePC5);
            System.out.println("testpipe result sgtin96: " + this.conversionChain(ePC5));
            this.testConversion(sGTIN64);
            System.out.println("SGTIN-64 TAG URI:  " + sGTIN64.getTagURI());
            System.out.println("SGTIN-64 Pure Identity URI:  " + sGTIN64.getPureIdentityURI());
            URI uRI5 = sGTIN64.getTagURI();
            EPC ePC6 = EPCFactory.getInstance().create(uRI5);
            System.out.println("SGTIN-64 TAG URI: " + ePC6.getTagURI());
            System.out.println("SGTIN-64 Pure Identity URI: " + ePC6.getPureIdentityURI());
            System.out.println("SGTIN-64 RawHexURI: " + ePC6.getRawHexURI());
            URI uRI6 = new URI("urn:epc:raw:64.x9800600190bc614e");
            EPC ePC7 = EPCFactory.getInstance().create(uRI6);
            System.out.println("SGTIN-64 rawHexEPC TAG URI: " + ePC7.getTagURI());
            System.out.println("SGTIN-64 rawHexEPC Pure Identity URI: " + ePC7.getPureIdentityURI());
            System.out.println("SGTIN-64 rawHexEPC  raw Hex URI: " + ePC7.getRawHexURI());
            long[] lArray = ePC7.getLongArray();
            EPC ePC8 = EPCFactory.getInstance().create(lArray);
            System.out.println("epc2 getRawHexURI: " + ePC8.getRawHexURI());
            System.out.println("epc2 getPureIdentityURI: " + ePC8.getPureIdentityURI());
            System.out.println("epc2 getTagURI: " + ePC8.getTagURI());
            System.out.println("epc2 getRawDecimalURI: " + ePC8.getRawDecimalURI());
            System.out.println("epc2 getRawDecimalURI: " + ePC8.getRawDecimalURI());
            sGTIN64 = EPCFactory.getInstance().createSGTIN64(3, "0073257", 200L, 12345678L);
            long l = System.currentTimeMillis();
            boolean bl = true;
            for (int i = 0; i < 1000; ++i) {
                bl = this.conversionChain(sGTIN64) && bl;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("time to process pipe 1000 times: " + (l2 - l));
            System.out.println("test pipe result: " + bl);
            System.out.println(sGTIN64.dump());
            System.out.println("toString(): " + sGTIN64);
        }
        catch (EPCException ePCException) {
            ePCException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
    }
}

