/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epchelpers;

import com.connecterra.ale.epchelpers.CompanyPrefixTable;
import com.connecterra.i18n.I18N;
import com.connecterra.util.MultiException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class EPCIndexTableLoader {
    private static final String c = "com.connecterra.ale.epchelpers.EPCIndexTableLoader";
    private static Logger b = Logger.getLogger("com.connecterra.ale.epchelpers.EPCIndexTableLoader");

    public static void loadFromURLs(List list) throws MultiException {
        MultiException multiException = new MultiException();
        if (list == null || list.size() == 0) {
            multiException.add(new TableException(I18N.get("No EPC Company Prefix translation table URLs specified")));
        }
        multiException.maybeThrow(I18N.get("Unable to load an EPC company prefix translation table:"), true);
        for (URL uRL : list) {
            Throwable throwable;
            b.fine("Attempting to read EPC Company Prefix translation table from " + uRL);
            try {
                EPCIndexTableLoader.b(uRL);
                b.info(I18N.get("Using {0} to provide EPC Company Prefix Index translations", uRL));
                return;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throwable = parserConfigurationException;
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throwable = factoryConfigurationError;
            }
            catch (SAXException sAXException) {
                throwable = sAXException;
            }
            catch (IOException iOException) {
                throwable = iOException;
            }
            TableException tableException = new TableException(I18N.get("for url {0}:", uRL) + throwable.getLocalizedMessage(), throwable);
            multiException.add(tableException);
            b.log(Level.FINE, tableException.getMessage(), tableException);
        }
        multiException.maybeThrow(I18N.get("Unable to load an EPC company prefix translation table:"), true);
    }

    private static void b(URL uRL) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        InputStream inputStream = uRL.openStream();
        InputSource inputSource = new InputSource(inputStream);
        GEPC64Table gEPC64Table = EPCIndexTableLoader.b(inputSource);
        Set set = gEPC64Table.b();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            GEPC64Table.Entry entry = (GEPC64Table.Entry)iterator.next();
            int n2 = entry.c();
            String string = entry.b();
            try {
                CompanyPrefixTable.addEntry(n2, string);
                ++n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private static GEPC64Table b(InputSource inputSource) throws ParserConfigurationException, FactoryConfigurationError, SAXException, IOException {
        SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
        EntryHandler entryHandler = new EntryHandler(sAXParser.getXMLReader());
        sAXParser.parse(inputSource, (DefaultHandler)entryHandler);
        return entryHandler.getGEPC64Table();
    }

    private static class GEPC64Table {
        private Date b = null;
        private Set c = new HashSet();

        private GEPC64Table() {
        }

        private void b(Date date) {
            this.b = date;
        }

        private void b(Entry entry) {
            this.c.add(entry);
        }

        private Set b() {
            return Collections.unmodifiableSet(this.c);
        }

        private static class Entry {
            private int c = -1;
            private String b = null;

            private Entry(int n, String string) {
                if (n < 0) {
                    throw new IllegalArgumentException(I18N.get("non valid company prefix index"));
                }
                if (string == null || "".equals(string.trim())) {
                    throw new IllegalArgumentException(I18N.get("non valid company code"));
                }
                this.c = n;
                this.b = string;
            }

            private int c() {
                return this.c;
            }

            private String b() {
                return this.b;
            }

            public int hashCode() {
                return (this.c + ":" + this.b).hashCode();
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof Entry) {
                    return ((Entry)object).b.equals(this.b) && ((Entry)object).c == this.c;
                }
                return false;
            }
        }
    }

    private static class EntryHandler
    extends BaseHandler {
        private GEPC64Table e = new GEPC64Table();

        public EntryHandler(XMLReader xMLReader) {
            super(xMLReader);
        }

        public GEPC64Table getGEPC64Table() {
            return this.e;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXParseException {
            if (string3.equals("entry")) {
                int n;
                int n2 = attributes.getLength();
                String string4 = null;
                String string5 = null;
                for (n = 0; n < n2; ++n) {
                    if (attributes.getQName(n).equals("index")) {
                        string4 = attributes.getValue(n);
                    }
                    if (!attributes.getQName(n).equals("companyPrefix")) continue;
                    string5 = attributes.getValue(n);
                }
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    b.log(Level.FINE, "index attribute \"" + string4 + "\" is invalid: " + numberFormatException, numberFormatException);
                    return;
                }
                this.getGEPC64Table().b(new GEPC64Table.Entry(n, string5));
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXParseException {
        }
    }

    private static class BaseHandler
    extends DefaultHandler {
        private Locator b;
        private ContentHandler c;
        private XMLReader d;

        protected BaseHandler(XMLReader xMLReader) {
            this.d = xMLReader;
        }

        protected XMLReader getParser() {
            return this.d;
        }

        public void setDocumentLocator(Locator locator) {
            this.b = locator;
        }

        protected void throwParseError(String string) throws SAXParseException {
            throw new SAXParseException(string, this.b);
        }

        protected void throwParseError(String string, Exception exception) throws SAXParseException {
            throw (SAXParseException)new SAXParseException(string, this.b).initCause(exception);
        }

        protected void pushHandler(BaseHandler baseHandler) {
            if (baseHandler.c != null) {
                throw new IllegalStateException(I18N.get("Already pushed handler"));
            }
            baseHandler.c = this.d.getContentHandler();
            this.d.setContentHandler(baseHandler);
        }

        protected void popHandler() {
            if (this.c == null) {
                throw new IllegalStateException(I18N.get("No previous handler"));
            }
            this.d.setContentHandler(this.c);
            this.c = null;
        }

        public void endElement(String string, String string2, String string3) throws SAXParseException {
            this.popHandler();
        }
    }

    private static class TableException
    extends Exception {
        public TableException(String string) {
            super(string);
        }

        public TableException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

