/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.telemetry.client;

import com.connecterra.ale.telemetry.api.DuplicateTelemetrySpecNameException;
import com.connecterra.ale.telemetry.api.NoSuchTelemetrySubscriberException;
import com.connecterra.ale.telemetry.api.Telemetry;
import com.connecterra.ale.telemetry.api.TelemetryFactory;
import com.connecterra.ale.telemetry.api.TelemetryReports;
import com.connecterra.ale.telemetry.api.TelemetrySpec;
import com.connecterra.ale.telemetry.api.TelemetrySpecValidationException;
import com.connecterra.ale.telemetry.api.TelemetrySubscriptionControls;
import com.connecterra.ale.telemetry.axis.AxisTelemetryFactory;
import com.connecterra.ale.telemetry.axis.adapters.DeviceInfoAdapter;
import com.connecterra.ale.telemetry.axis.adapters.TelemetryReportsAdapter;
import com.connecterra.ale.telemetry.axis.adapters.TelemetrySpecAdapter;
import com.connecterra.ale.telemetry.axis.adapters.TelemetrySubscriptionControlsAdapter;
import com.connecterra.ale.telemetry.axis.schema.DeviceInfo;
import com.connecterra.ale.telemetry.axis.service.ArrayOfString;
import com.connecterra.ale.telemetry.axis.service.Define;
import com.connecterra.ale.telemetry.axis.service.EmptyParms;
import com.connecterra.ale.telemetry.axis.service.Get;
import com.connecterra.ale.telemetry.axis.service.GetDeviceInfo;
import com.connecterra.ale.telemetry.axis.service.InvalidTelemetryURIException;
import com.connecterra.ale.telemetry.axis.service.ListDeviceInfo;
import com.connecterra.ale.telemetry.axis.service.ListOfDeviceInfo;
import com.connecterra.ale.telemetry.axis.service.ListSubscribers;
import com.connecterra.ale.telemetry.axis.service.NoSuchDeviceException;
import com.connecterra.ale.telemetry.axis.service.NoSuchTelemetrySpecNameException;
import com.connecterra.ale.telemetry.axis.service.Poll;
import com.connecterra.ale.telemetry.axis.service.Subscribe;
import com.connecterra.ale.telemetry.axis.service.TelemetryEngineException;
import com.connecterra.ale.telemetry.axis.service.TelemetryServiceBindingStub;
import com.connecterra.ale.telemetry.axis.service.TelemetryServiceLocator;
import com.connecterra.ale.telemetry.axis.service.TelemetryServicePortType;
import com.connecterra.ale.telemetry.axis.service.Undefine;
import com.connecterra.ale.telemetry.axis.service.Unsubscribe;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;

public class AxisTelemetryClient
implements Telemetry {
    private TelemetryServicePortType b;

    public AxisTelemetryClient(URL uRL) throws RemoteException {
        if (uRL == null) {
            throw new IllegalArgumentException(I18N.get("Specified ALE Service URL is null"));
        }
        Logger logger = Logger.getLogger("org.apache.axis");
        logger.setLevel(Level.OFF);
        TelemetryServiceLocator telemetryServiceLocator = new TelemetryServiceLocator();
        try {
            this.b = telemetryServiceLocator.getTelemetryService(uRL);
        }
        catch (ServiceException serviceException) {
            throw new RemoteException(serviceException.getMessage(), serviceException);
        }
        this.setTimeout(600000L);
    }

    public void setTimeout(long l) {
        ((TelemetryServiceBindingStub)this.b).setTimeout((int)l);
    }

    public long getTimeout() {
        return ((TelemetryServiceBindingStub)this.b).getTimeout();
    }

    public TelemetryFactory getTelemetryFactory() {
        return AxisTelemetryFactory.getInstance();
    }

    public void define(String string, TelemetrySpec telemetrySpec) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, TelemetrySpecValidationException, DuplicateTelemetrySpecNameException, com.connecterra.ale.telemetry.api.NoSuchDeviceException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec name is null."));
        }
        if (telemetrySpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec is null."));
        }
        Define define = new Define();
        define.setTlmSpecName(string);
        define.setSpec(TelemetrySpecAdapter.apiToAxis(telemetrySpec));
        try {
            this.b.define(define);
        }
        catch (com.connecterra.ale.telemetry.axis.service.TelemetrySpecValidationException telemetrySpecValidationException) {
            throw new TelemetrySpecValidationException(telemetrySpecValidationException.getMessage(), telemetrySpecValidationException);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
        catch (NoSuchDeviceException noSuchDeviceException) {
            throw new com.connecterra.ale.telemetry.api.NoSuchDeviceException(noSuchDeviceException.getMessage(), noSuchDeviceException);
        }
        catch (com.connecterra.ale.telemetry.axis.service.DuplicateTelemetrySpecNameException duplicateTelemetrySpecNameException) {
            throw new DuplicateTelemetrySpecNameException(duplicateTelemetrySpecNameException.getMessage(), duplicateTelemetrySpecNameException);
        }
    }

    public void undefine(String string) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec name is null."));
        }
        Undefine undefine = new Undefine();
        undefine.setTlmSpecName(string);
        try {
            this.b.undefine(undefine);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
        catch (NoSuchTelemetrySpecNameException noSuchTelemetrySpecNameException) {
            throw new com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException(noSuchTelemetrySpecNameException.getMessage(), noSuchTelemetrySpecNameException);
        }
    }

    public TelemetrySpec get(String string) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec name is null."));
        }
        Get get = new Get();
        get.setTlmSpecName(string);
        try {
            com.connecterra.ale.telemetry.axis.schema.TelemetrySpec telemetrySpec = this.b.get(get);
            if (telemetrySpec == null) {
                return null;
            }
            return new TelemetrySpecAdapter(telemetrySpec);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
    }

    public List listTelemetrySpecNames() throws com.connecterra.ale.telemetry.api.TelemetryEngineException, RemoteException {
        try {
            ArrayOfString arrayOfString = this.b.listTelemetrySpecNames(new EmptyParms());
            return AxisTelemetryClient.c(arrayOfString);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
    }

    public TelemetryReports poll(String string) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec name is null."));
        }
        Poll poll = new Poll();
        poll.setTlmSpecName(string);
        try {
            com.connecterra.ale.telemetry.axis.schema.TelemetryReports telemetryReports = this.b.poll(poll);
            return new TelemetryReportsAdapter(telemetryReports);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
        catch (NoSuchTelemetrySpecNameException noSuchTelemetrySpecNameException) {
            throw new com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException(noSuchTelemetrySpecNameException.getMessage(), noSuchTelemetrySpecNameException);
        }
    }

    public void subscribe(String string, URI uRI, boolean bl, TelemetrySubscriptionControls telemetrySubscriptionControls) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException, com.connecterra.ale.telemetry.api.InvalidTelemetryURIException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        try {
            Subscribe subscribe = new Subscribe();
            subscribe.setTlmSpecName(string);
            subscribe.setControls(TelemetrySubscriptionControlsAdapter.apiToAxis(telemetrySubscriptionControls));
            subscribe.setIncludeHistory(bl);
            subscribe.setTlmReportURI(uRI.toString());
            this.b.subscribe(subscribe);
            return;
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
        catch (NoSuchTelemetrySpecNameException noSuchTelemetrySpecNameException) {
            throw new com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException(noSuchTelemetrySpecNameException.getMessage(), noSuchTelemetrySpecNameException);
        }
        catch (InvalidTelemetryURIException invalidTelemetryURIException) {
            throw new com.connecterra.ale.telemetry.api.InvalidTelemetryURIException(invalidTelemetryURIException.getMessage(), invalidTelemetryURIException);
        }
    }

    public List listSubscribers(String string) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec name is null."));
        }
        ArrayOfString arrayOfString = null;
        try {
            ListSubscribers listSubscribers = new ListSubscribers();
            listSubscribers.setTlmSpecName(string);
            arrayOfString = this.b.listSubscribers(listSubscribers);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
        catch (NoSuchTelemetrySpecNameException noSuchTelemetrySpecNameException) {
            throw new com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException(noSuchTelemetrySpecNameException.getMessage(), noSuchTelemetrySpecNameException);
        }
        try {
            return AxisTelemetryClient.b(arrayOfString);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public void unsubscribe(String string, URI uRI) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException, NoSuchTelemetrySubscriberException, com.connecterra.ale.telemetry.api.InvalidTelemetryURIException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified TelemetrySpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        try {
            Unsubscribe unsubscribe = new Unsubscribe();
            unsubscribe.setTlmSpecName(string);
            unsubscribe.setTlmReportURI(uRI.toString());
            this.b.unsubscribe(unsubscribe);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
        catch (NoSuchTelemetrySpecNameException noSuchTelemetrySpecNameException) {
            throw new com.connecterra.ale.telemetry.api.NoSuchTelemetrySpecNameException(noSuchTelemetrySpecNameException.getMessage(), noSuchTelemetrySpecNameException);
        }
        catch (InvalidTelemetryURIException invalidTelemetryURIException) {
            throw new com.connecterra.ale.telemetry.api.InvalidTelemetryURIException(invalidTelemetryURIException.getMessage(), invalidTelemetryURIException);
        }
        catch (com.connecterra.ale.telemetry.axis.service.NoSuchTelemetrySubscriberException noSuchTelemetrySubscriberException) {
            throw new NoSuchTelemetrySubscriberException(noSuchTelemetrySubscriberException.getMessage(), noSuchTelemetrySubscriberException);
        }
    }

    public List listDeviceInfo(boolean bl) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, RemoteException {
        try {
            ListDeviceInfo listDeviceInfo = new ListDeviceInfo();
            listDeviceInfo.setIncludeAttributes(bl);
            ListOfDeviceInfo listOfDeviceInfo = this.b.listDeviceInfo(listDeviceInfo);
            return AxisTelemetryClient.b(listOfDeviceInfo);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
    }

    public com.connecterra.ale.telemetry.api.DeviceInfo getDeviceInfo(String string, boolean bl) throws com.connecterra.ale.telemetry.api.TelemetryEngineException, RemoteException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified deviceID is null."));
        }
        try {
            GetDeviceInfo getDeviceInfo = new GetDeviceInfo();
            getDeviceInfo.setDeviceID(string);
            getDeviceInfo.setIncludeAttributes(bl);
            DeviceInfo deviceInfo = this.b.getDeviceInfo(getDeviceInfo);
            return new DeviceInfoAdapter(deviceInfo);
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
    }

    public String getEdgeServerDeviceID() throws com.connecterra.ale.telemetry.api.TelemetryEngineException, RemoteException {
        try {
            return this.b.getEdgeServerDeviceID(new EmptyParms());
        }
        catch (TelemetryEngineException telemetryEngineException) {
            throw new com.connecterra.ale.telemetry.api.TelemetryEngineException(telemetryEngineException.getMessage(), telemetryEngineException);
        }
    }

    private static List b(ListOfDeviceInfo listOfDeviceInfo) {
        if (listOfDeviceInfo == null) {
            return Collections.EMPTY_LIST;
        }
        DeviceInfo[] deviceInfoArray = listOfDeviceInfo.getDeviceInfo();
        if (deviceInfoArray == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DeviceInfoAdapter> arrayList = new ArrayList<DeviceInfoAdapter>();
        for (int i = 0; i < deviceInfoArray.length; ++i) {
            arrayList.add(new DeviceInfoAdapter(deviceInfoArray[i]));
        }
        return arrayList;
    }

    private static List c(ArrayOfString arrayOfString) {
        if (arrayOfString == null) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(stringArray);
    }

    private static List b(ArrayOfString arrayOfString) throws URISyntaxException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (arrayOfString == null) {
            return arrayList;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            arrayList.add(new URI(string));
        }
        return arrayList;
    }
}

