/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.axis.adapters;

import com.connecterra.alepc.api.DataSpec;
import com.connecterra.alepc.api.EPCCacheDataSpec;
import com.connecterra.alepc.api.LiteralDataSpec;
import com.connecterra.alepc.api.PCSpecValidationException;
import com.connecterra.alepc.api.ParamDataSpec;
import com.connecterra.alepc.api.WriteOpSpec;
import com.connecterra.alepc.axis.adapters.DataSpecAdapter;
import com.connecterra.alepc.axis.adapters.OpSpecAdapter;
import com.connecterra.alepc.axis.schema.WriteOperationSpec;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;

public class WriteOpSpecAdapter
implements WriteOpSpec,
OpSpecAdapter {
    private WriteOperationSpec f;
    private DataSpec e;

    public static WriteOperationSpec aleToAxis(WriteOpSpec writeOpSpec) {
        if (writeOpSpec == null) {
            return null;
        }
        if (writeOpSpec instanceof WriteOpSpecAdapter) {
            return ((WriteOpSpecAdapter)writeOpSpec).d();
        }
        return new WriteOpSpecAdapter(writeOpSpec).d();
    }

    public static WriteOpSpec axisToALE(WriteOperationSpec writeOperationSpec) throws URISyntaxException, PCSpecValidationException {
        return writeOperationSpec == null ? null : new WriteOpSpecAdapter(writeOperationSpec);
    }

    public WriteOpSpecAdapter(URI uRI, DataSpec dataSpec) {
        this.f = new WriteOperationSpec();
        this.e = dataSpec;
        this.f.setField(uRI.toString());
        if (dataSpec instanceof LiteralDataSpec) {
            this.f.setLiteral(((LiteralDataSpec)dataSpec).getValue().toString());
        } else if (dataSpec instanceof ParamDataSpec) {
            this.f.setParam(((ParamDataSpec)dataSpec).getParamName());
        } else if (dataSpec instanceof EPCCacheDataSpec) {
            this.f.setEpcCache(((EPCCacheDataSpec)dataSpec).getEPCCache());
        }
    }

    WriteOpSpecAdapter(WriteOpSpec writeOpSpec) {
        this(writeOpSpec.getField(), writeOpSpec.getDataSpec());
    }

    private WriteOpSpecAdapter(WriteOperationSpec writeOperationSpec) throws URISyntaxException, PCSpecValidationException {
        this.f = writeOperationSpec;
        if (this.f.getField() == null) {
            throw new PCSpecValidationException(I18N.get("Write Operation Specification must include field"));
        }
        new URI(writeOperationSpec.getField());
        this.e = writeOperationSpec.getLiteral() != null ? DataSpecAdapter.createLiteral(writeOperationSpec.getLiteral()) : DataSpecAdapter.createOther(writeOperationSpec.getEpcCache(), writeOperationSpec.getParam());
    }

    public URI getField() {
        try {
            return new URI(this.f.getField());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException();
        }
    }

    public DataSpec getDataSpec() {
        return this.e;
    }

    private WriteOperationSpec d() {
        return this.f;
    }
}

