/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.connectionPool;

import com.connecterra.connectionPool.Connection;
import com.connecterra.connectionPool.ConnectionCreateException;
import com.connecterra.connectionPool.ConnectionPool;
import com.connecterra.i18n.I18N;
import com.connecterra.util.CircularArrayList;
import com.connecterra.util.Queue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractConnectionPool
implements ConnectionPool {
    private Queue g = new CircularArrayList();
    private Set e = new HashSet();
    private String d;
    private int h;
    private int f;
    private Logger b;
    private boolean c;

    protected AbstractConnectionPool(String string) {
        this.d = string;
        this.h = 1;
        this.f = Integer.MAX_VALUE;
        this.b = Logger.getLogger("com.connecterra.connectionPool.AbstractConnectionPool." + this.d);
    }

    public void setHighWater(int n) {
        this.h = n;
    }

    public void setMaximum(int n) {
        this.f = n;
    }

    public synchronized Connection checkout() throws InterruptedException, ConnectionCreateException {
        Connection connection;
        if (this.c) {
            throw new ConnectionCreateException(I18N.get("tried to check out connection after connection pool closed"));
        }
        if (this.g.size() == 0) {
            if (this.e.size() < this.f) {
                connection = this.createNewConnection();
                if (connection == null) {
                    throw new ConnectionCreateException(I18N.get("adding to pool failed"));
                }
                this.g.addLast(connection);
            } else {
                while (this.g.isEmpty()) {
                    this.wait();
                }
            }
        }
        connection = (Connection)this.g.removeFirst();
        this.e.add(connection);
        return connection;
    }

    public synchronized void checkin(Connection connection) {
        if (this.c) {
            this.b.fine("Checking in connection after close - ignoring");
            return;
        }
        boolean bl = this.e.remove(connection);
        if (!bl) {
            if (this.g.contains(connection)) {
                throw new IllegalStateException("Connection checked in twice");
            }
            throw new IllegalArgumentException("Unmanaged Connection checked in");
        }
        if (this.e.size() + this.g.size() >= this.h) {
            this.connectionRemovedFromPool(connection, null);
            connection.close();
        } else if (connection.getSuspect() != null && !connection.isAlive()) {
            this.connectionRemovedFromPool(connection, connection.getSuspect());
            connection.close();
        } else {
            connection.clearSuspect();
            this.addConnectionToPool(connection);
        }
    }

    public synchronized void ensureConnections(int n) throws ConnectionCreateException {
        if (n > this.f) {
            n = this.f;
        }
        Iterator iterator = this.g.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (connection.isAlive()) continue;
            iterator.remove();
            this.connectionRemovedFromPool(connection, null);
            connection.close();
        }
        int n2 = this.g.size() + this.e.size();
        for (int i = 0; i < n - n2; ++i) {
            Connection connection = this.createNewConnection();
            if (connection == null) {
                throw new ConnectionCreateException(I18N.get("adding to pool failed"));
            }
            this.g.addLast(connection);
            this.notify();
        }
    }

    public synchronized void close() {
        this.c = true;
        Iterator iterator = this.e.iterator();
        while (iterator.hasNext()) {
            ((Connection)iterator.next()).close();
        }
        this.e.clear();
        iterator = this.g.iterator();
        while (iterator.hasNext()) {
            ((Connection)iterator.next()).close();
        }
        this.g.clear();
    }

    public synchronized void addConnectionToPool(Connection connection) {
        this.g.addLast(connection);
        this.notify();
    }

    public synchronized boolean removeConnectionFromPool(Connection connection) {
        return this.g.remove(connection);
    }

    public synchronized boolean poolContainsConnection(Connection connection) {
        return this.g.contains(connection) || this.e.contains(connection);
    }

    protected abstract Connection createNewConnection() throws ConnectionCreateException;

    protected void connectionRemovedFromPool(Connection connection, Exception exception) {
        this.b.log(Level.FINE, "Removing connection from pool " + this.d, exception);
    }
}

