/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.modbus.client;

import com.connecterra.modbus.client.MODBUSClientCallback;
import com.connecterra.modbus.client.TransactionTable;
import com.connecterra.modbus.protocol.ADU;
import com.connecterra.modbus.protocol.ProtocolException;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class MODBUSClientReceiver {
    private static final Logger d = Logger.getLogger("com.connecterra.modbus.client");
    private DataInputStream c;
    private TransactionTable b;

    public MODBUSClientReceiver(InputStream inputStream, TransactionTable transactionTable) {
        this.c = new DataInputStream(inputStream);
        this.b = transactionTable;
    }

    public void run() throws ProtocolException {
        while (true) {
            ADU aDU;
            try {
                this.b.waitForTransactions();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            try {
                aDU = ADU.read(this.c, true);
            }
            catch (IOException iOException) {
                throw new ProtocolException(iOException.getMessage(), iOException);
            }
            MODBUSClientCallback mODBUSClientCallback = this.b.lookupAndUnregister(aDU.getTransactionID());
            if (d.isLoggable(Level.FINER)) {
                d.finer("invoking callback for ModBus transactionID=" + aDU.getTransactionID() + "; pdu=" + System.identityHashCode(aDU.getPDU()));
            }
            if (mODBUSClientCallback == null) continue;
            mODBUSClientCallback.receive(aDU.getPDU());
        }
    }
}

