/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.modbus.client;

import com.connecterra.modbus.client.MODBUSClientCallback;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class TransactionTable {
    private static final Logger f = Logger.getLogger("com.connecterra.modbus.client");
    private int e;
    private MODBUSClientCallback[] d;
    private int b = 0;
    private int c = 0;

    public TransactionTable(int n) {
        this.e = n == -1 ? 16 : n;
        this.d = new MODBUSClientCallback[this.e];
    }

    public synchronized int register(MODBUSClientCallback mODBUSClientCallback) {
        for (int i = 0; i < this.e; ++i) {
            int n = this.b;
            this.b = (this.b + 1) % this.e;
            if (this.d[n] != null) continue;
            this.d[n] = mODBUSClientCallback;
            ++this.c;
            return n + 1;
        }
        return -1;
    }

    public synchronized MODBUSClientCallback lookupAndUnregister(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.e) {
            return null;
        }
        MODBUSClientCallback mODBUSClientCallback = this.d[n2];
        this.d[n2] = null;
        --this.c;
        return mODBUSClientCallback;
    }

    public synchronized void abortAllTransactions(IOException iOException) {
        for (int i = 0; i < this.e; ++i) {
            if (this.d[i] == null) continue;
            if (f.isLoggable(Level.FINER)) {
                f.finer("aborting ModBus transactionID=" + (i + 1));
            }
            this.d[i].connectionError(iOException);
            this.d[i] = null;
        }
        this.e = 0;
    }

    public synchronized void waitForTransactions() throws InterruptedException {
        while (this.c == 0) {
            this.wait();
        }
    }

    protected synchronized void notifyReadyforRead() {
        this.notifyAll();
    }
}

