/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCInboundMessage;
import com.connecterra.plc.PLCMessageConvention;
import com.connecterra.plc.PLCOutboundMessage;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class MultipleItemMessageConvention
implements PLCMessageConvention {
    private String z = null;
    private PLCTransport ab = null;
    private static Logger y = Logger.getLogger(MultipleItemMessageConvention.class.getName());

    public void initialize(String string, PLCTransport pLCTransport, RawConfig rawConfig) throws ConfigValidationException {
        this.z = string;
        this.ab = pLCTransport;
    }

    public PLCTransport getTransport() {
        return this.ab;
    }

    public PLCOutboundMessage createOutboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        return new OutboundMessage(string, rawConfig);
    }

    public PLCInboundMessage createInboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        throw new ConfigValidationException(I18N.get("the multiple item convention does not support inbound messages"));
    }

    public boolean isAlive() {
        return this.ab.isAlive();
    }

    private class OutboundMessage
    implements PLCOutboundMessage {
        private List kb;

        public OutboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
            ValidatedConfig validatedConfig = new ValidatedConfig();
            validatedConfig.addListItem("items");
            validatedConfig.readFrom(rawConfig);
            this.kb = Arrays.asList(validatedConfig.getListValue("items"));
        }

        public PLCMessageConvention getMessageConvention() {
            return MultipleItemMessageConvention.this;
        }

        public void invoke(List list) throws PLCException, IOException {
            if (list == null) {
                throw new PLCException(I18N.get("expected {0} values, but got none", this.kb.size()));
            }
            if (list.size() != this.kb.size()) {
                throw new PLCException(I18N.get("expected {0} values, but got {1}", this.kb.size(), list.size()));
            }
            MultipleItemMessageConvention.this.ab.write(this.kb, list);
        }
    }
}

