/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCFactory;
import com.connecterra.plc.PLCListener;
import com.connecterra.plctypes.AbstractPLCTransport;
import com.connecterra.plctypes.PLCPollTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import com.starthis.enip.iec.types.EPATH;
import com.starthis.enip.iec.types.EnipARRAY;
import com.starthis.enip.iec.types.segments.Port;
import com.starthis.enip.iec.types.segments.Segment;
import com.starthis.hardware.rockwell.ab.clgx.ClgxCommunicationException;
import com.starthis.hardware.rockwell.ab.clgx.ClgxTagNotExistException;
import com.starthis.hardware.rockwell.ab.clgx.ClgxTagTypeMismatchException;
import com.starthis.hardware.rockwell.ab.clgx.ControlLogix;
import com.starthis.hardware.rockwell.ab.clgx.external.ControlLogixBeanExternal;
import com.starthis.hardware.rockwell.ab.clgx.types.ClgxSTRING;
import com.starthis.hardware.rockwell.ab.clgx.util.ClgxLicense;
import com.starthis.iec.types.ANY;
import com.starthis.iec.types.ANY_STRING;
import com.starthis.iec.types.ARRAY;
import com.starthis.iec.types.BOOL;
import com.starthis.iec.types.DINT;
import com.starthis.iec.types.INT;
import com.starthis.iec.types.IecClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.management.MalformedObjectNameException;
import javax.resource.ResourceException;

public class StarThisTransport
extends PLCPollTransport {
    Logger s_log = Logger.getLogger("com.connecterra.plctypes.StarThisTransport");
    private boolean q = false;
    private String p;
    private String o;
    private int r;
    private EPATH m;
    private ControlLogix n;

    public void initialize(PLCFactory pLCFactory, String string, RawConfig rawConfig) throws ConfigValidationException {
        super.initialize(pLCFactory, "StarThisTransport " + string, rawConfig);
        this.p = string;
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addFileItem("licenseDir", true);
        validatedConfig.addFileItem("storageDir", true);
        validatedConfig.addStringItem("hostname");
        validatedConfig.addIntegerItem("backplanePort");
        validatedConfig.readFrom(rawConfig);
        ClgxLicense.setLicenseFolder((String)validatedConfig.getFileValue("licenseDir").toString());
        ControlLogixBeanExternal.setRootStr((String)validatedConfig.getFileValue("storageDir").toString());
        this.o = validatedConfig.getStringValue("hostname");
        this.r = validatedConfig.getIntegerValue("backplanePort");
        this.m = new EPATH();
        this.m.add((Segment)new Port(44818, this.o));
        this.m.add((Segment)new Port(1, this.r));
    }

    private static IOException b(Throwable throwable) {
        IOException iOException = new IOException(throwable.getMessage());
        iOException.initCause(throwable);
        return iOException;
    }

    protected void connect() throws IOException, PLCException {
        if (this.n != null) {
            return;
        }
        this.s_log.fine("connecting...");
        if (!this.q) {
            try {
                ControlLogixBeanExternal.connect();
                this.q = true;
            }
            catch (ResourceException resourceException) {
                throw StarThisTransport.b(resourceException);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new PLCException(malformedObjectNameException.getMessage(), malformedObjectNameException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PLCException(classNotFoundException.getMessage(), classNotFoundException);
            }
        }
        this.s_log.finer("m_hostname: " + this.o);
        this.s_log.finer("m_backplanePort: " + this.r);
        this.s_log.finer("m_ePath: " + this.m);
        try {
            this.n = ControlLogixBeanExternal.findPLC((EPATH)this.m);
        }
        catch (RuntimeException runtimeException) {
            this.s_log.log(Level.SEVERE, I18N.get("Error opening PLC: {0}", runtimeException.getMessage()), runtimeException);
            throw runtimeException;
        }
        try {
            if (this.n == null) {
                this.n = ControlLogixBeanExternal.create((EPATH)this.m);
                this.n.updateName();
            }
            this.n.updateTagInformation();
            this.s_log.fine("connected.");
        }
        catch (CreateException createException) {
            this.d();
            throw StarThisTransport.b(createException);
        }
        catch (ClgxCommunicationException clgxCommunicationException) {
            this.d();
            throw StarThisTransport.b(clgxCommunicationException);
        }
    }

    private void d() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ANY b(String string) throws IOException, PLCException {
        try {
            ANY aNY;
            if (this.s_log.isLoggable(Level.FINER)) {
                this.s_log.finer("reading itemName=" + string);
            }
            StarThisTransport starThisTransport = this;
            synchronized (starThisTransport) {
                aNY = this.n.getTag(string);
            }
            if (this.s_log.isLoggable(Level.FINER)) {
                this.s_log.finer("read itemName=" + string + " => " + aNY);
            }
            return aNY;
        }
        catch (ClgxCommunicationException clgxCommunicationException) {
            this.d();
            throw StarThisTransport.b(clgxCommunicationException);
        }
        catch (ClgxTagNotExistException clgxTagNotExistException) {
            throw new PLCException(I18N.get("Tag does not exist: {0} (tag is {1})", (Object)clgxTagNotExistException.getMessage(), (Object)string), clgxTagNotExistException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List b(List list, Level level) throws IOException, PLCException {
        try {
            List list2;
            if (this.s_log.isLoggable(level)) {
                this.s_log.log(level, "reading itemNames=" + list);
            }
            StarThisTransport starThisTransport = this;
            synchronized (starThisTransport) {
                list2 = this.n.getTags(list);
            }
            if (this.s_log.isLoggable(level)) {
                this.s_log.log(level, "read itemNames=" + list + " => " + list2);
            }
            return list2;
        }
        catch (ClgxCommunicationException clgxCommunicationException) {
            this.d();
            throw StarThisTransport.b(clgxCommunicationException);
        }
        catch (ClgxTagNotExistException clgxTagNotExistException) {
            throw new PLCException(I18N.get("Tag does not exist: {0} (tags are {1})", (Object)clgxTagNotExistException.getMessage(), (Object)list), clgxTagNotExistException);
        }
        catch (ClgxTagTypeMismatchException clgxTagTypeMismatchException) {
            throw new PLCException(clgxTagTypeMismatchException.getMessage(), clgxTagTypeMismatchException);
        }
    }

    protected List getReadings(List list) throws IOException, PLCException {
        List list2 = this.b(list, Level.FINEST);
        ArrayList<StarThisItemValue> arrayList = new ArrayList<StarThisItemValue>(list2.size());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            StarThisItemValue starThisItemValue = new StarThisItemValue((ANY)iterator.next());
            arrayList.add(starThisItemValue);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(Map map) throws IOException, PLCException {
        try {
            if (this.s_log.isLoggable(Level.FINER)) {
                this.s_log.finer("setting itemNames to values: " + map);
            }
            StarThisTransport starThisTransport = this;
            synchronized (starThisTransport) {
                this.n.setTags(map);
            }
        }
        catch (ClgxCommunicationException clgxCommunicationException) {
            this.d();
            throw StarThisTransport.b(clgxCommunicationException);
        }
        catch (ClgxTagNotExistException clgxTagNotExistException) {
            throw new PLCException(I18N.get("Tag does not exist: {0} (tags are {1})", (Object)clgxTagNotExistException.getMessage(), map.keySet()), clgxTagNotExistException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(String string, ANY aNY) throws PLCException, IOException {
        try {
            if (this.s_log.isLoggable(Level.FINER)) {
                this.s_log.finer("setting itemName=" + string + " to tag=" + aNY);
            }
            StarThisTransport starThisTransport = this;
            synchronized (starThisTransport) {
                this.n.setTag(string, aNY);
            }
        }
        catch (ClgxCommunicationException clgxCommunicationException) {
            this.d();
            throw StarThisTransport.b(clgxCommunicationException);
        }
        catch (ClgxTagNotExistException clgxTagNotExistException) {
            throw new PLCException(I18N.get("Tag does not exist: {0} (tag is {1})", (Object)clgxTagNotExistException.getMessage(), (Object)string), clgxTagNotExistException);
        }
        catch (ClgxTagTypeMismatchException clgxTagTypeMismatchException) {
            throw new PLCException(clgxTagTypeMismatchException.getMessage(), clgxTagTypeMismatchException);
        }
    }

    public List read(List list) throws IOException, PLCException {
        this.connect();
        List list2 = this.b(list, Level.FINER);
        ArrayList<Object> arrayList = new ArrayList<Object>(list2.size());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.b((ANY)iterator.next()));
        }
        return arrayList;
    }

    public void write(List arrayList, List arrayList2) throws IOException, PLCException {
        Object object;
        LinkedHashMap<String, ANY> linkedHashMap;
        if (arrayList.size() != arrayList2.size()) {
            throw new IllegalArgumentException("itemNames and values must have same size");
        }
        this.connect();
        String string = (String)arrayList.get(arrayList.size() - 1);
        this.c(string);
        if (string.endsWith("]")) {
            linkedHashMap = arrayList2.get(arrayList2.size() - 1);
            int n = string.lastIndexOf(91);
            object = string.substring(0, n);
            if (arrayList.contains(object)) {
                int n2 = Integer.parseInt(string.substring(n + 1, string.length() - 1));
                boolean bl = false;
                this.s_log.finer("will replace " + (String)object + "[" + n2 + "] with " + linkedHashMap);
                arrayList = new ArrayList(arrayList);
                arrayList2 = new ArrayList(arrayList2);
                ListIterator listIterator = arrayList.listIterator();
                ListIterator listIterator2 = arrayList2.listIterator();
                while (listIterator.hasNext()) {
                    String string2 = (String)listIterator.next();
                    Object e = listIterator2.next();
                    if (string2.equals(object)) {
                        if (!(e instanceof List)) {
                            throw new PLCException(I18N.get("value corresponding to array name {0} is not an array", string2));
                        }
                        ArrayList<LinkedHashMap<String, ANY>> arrayList3 = new ArrayList<LinkedHashMap<String, ANY>>((List)e);
                        arrayList3.set(n2, linkedHashMap);
                        listIterator2.set(arrayList3);
                        bl = true;
                        continue;
                    }
                    if (!string2.equals(string) || !bl) continue;
                    listIterator.remove();
                    listIterator2.remove();
                }
            }
        }
        linkedHashMap = new LinkedHashMap(arrayList2.size());
        Iterator iterator = arrayList.iterator();
        object = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            this.c(string3);
            linkedHashMap.put(string3, this.b(string3, object.next()));
        }
        this.b(linkedHashMap);
    }

    private void c(String string) throws PLCException, IOException {
        IecClass iecClass = this.n.getMetadata(string);
        if (iecClass == null) {
            throw new PLCException(I18N.get("Unrecognized tag: {0}", string));
        }
    }

    private Object b(ANY aNY) throws PLCException {
        if (aNY instanceof INT) {
            return new Short(((INT)aNY).getJavaValue());
        }
        if (aNY instanceof DINT) {
            return new Integer(((DINT)aNY).getJavaValue());
        }
        if (aNY instanceof ANY_STRING) {
            return new String(((ANY_STRING)aNY).asString());
        }
        if (aNY instanceof BOOL) {
            return ((BOOL)aNY).getJavaValue();
        }
        if (aNY instanceof ARRAY) {
            ARRAY aRRAY = (ARRAY)aNY;
            ArrayList<Object> arrayList = new ArrayList<Object>(aRRAY.length());
            for (int i = 0; i < aRRAY.length(); ++i) {
                arrayList.add(this.b(aRRAY.get(i)));
            }
            return arrayList;
        }
        throw new PLCException(I18N.get("Read unsupported IEC class {0}", aNY.getIecClass().getName()));
    }

    private ANY b(String string, Object object) throws PLCException, IOException {
        IecClass iecClass = this.n.getMetadata(string);
        return this.b(iecClass, object);
    }

    private ANY b(IecClass iecClass, Object object) throws PLCException, IOException {
        INT iNT;
        if (object instanceof Short) {
            iNT = new INT(((Short)object).shortValue());
        } else if (object instanceof Integer) {
            iNT = new DINT(((Integer)object).intValue());
        } else if (object instanceof String) {
            iNT = new ClgxSTRING((String)object, false);
        } else if (object instanceof Boolean) {
            iNT = new BOOL(((Boolean)object).booleanValue());
        } else if (object instanceof List) {
            List list = (List)object;
            EnipARRAY enipARRAY = new EnipARRAY(iecClass);
            int n = 0;
            if (list.size() != enipARRAY.length()) {
                throw new PLCException(I18N.get("Java array value must have {0} elements", enipARRAY.length()));
            }
            for (Object e : list) {
                ANY aNY = this.b(iecClass.getComponentType(), e);
                enipARRAY.set(n, aNY);
                ++n;
            }
            iNT = enipARRAY;
        } else {
            throw new PLCException(I18N.get("Java class {0} is not supported", object.getClass().getName()));
        }
        if (!iecClass.equals((Object)iNT.getIecClass())) {
            throw new PLCException(I18N.get("Java type {0} is not compatible with tag type {1}", object.getClass(), (Object)iecClass));
        }
        return iNT;
    }

    public void addListener(String string, PLCListener pLCListener, Object object) throws IOException, PLCException {
        Iterator iterator;
        this.connect();
        this.c(string);
        List list = pLCListener.getExtraItems();
        if (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                this.c((String)iterator.next());
            }
        }
        iterator = object == null ? null : this.b(string, object);
        StarThisItemValue starThisItemValue = null;
        if (iterator != null) {
            starThisItemValue = new StarThisItemValue((ANY)iterator);
        }
        this.addIVListener(string, pLCListener, starThisItemValue);
    }

    public boolean isAlive() {
        return this.n != null;
    }

    private class StarThisItemValue
    extends AbstractPLCTransport.ItemValue {
        public ANY m_value;

        public StarThisItemValue(ANY aNY) {
            this.m_value = aNY;
        }

        public Object getValue() throws PLCException {
            return StarThisTransport.this.b(this.m_value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof StarThisItemValue)) {
                return false;
            }
            return this.m_value.equals(((StarThisItemValue)object).m_value);
        }

        public int hashCode() {
            return this.m_value.hashCode() + 1225;
        }
    }
}

