/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.encoding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis.encoding.DefaultSOAPEncodingTypeMappingImpl;
import org.apache.axis.encoding.DefaultTypeMappingImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingDelegate;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.utils.Messages;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private HashMap mapTM = new HashMap();
    private TypeMapping defaultDelTM = new TypeMappingDelegate(DefaultTypeMappingImpl.getSingleton());

    public TypeMappingRegistryImpl() {
        this.register("http://schemas.xmlsoap.org/soap/encoding/", new DefaultSOAPEncodingTypeMappingImpl());
    }

    public void delegate(TypeMappingRegistry secondaryTMR) {
        if (secondaryTMR == null || secondaryTMR == this) {
            return;
        }
        String[] keys = secondaryTMR.getRegisteredEncodingStyleURIs();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                try {
                    String nsURI = keys[i];
                    TypeMapping tm = (TypeMapping)this.getTypeMapping(nsURI);
                    if (tm == null || tm == this.getDefaultTypeMapping()) {
                        tm = (TypeMapping)this.createTypeMapping();
                        tm.setSupportedEncodings(new String[]{nsURI});
                        this.register(nsURI, tm);
                    }
                    if (tm != null) {
                        TypeMapping del = (TypeMapping)((TypeMappingRegistryImpl)secondaryTMR).mapTM.get(nsURI);
                        tm.setDelegate(del);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (this.defaultDelTM != null) {
            this.defaultDelTM.setDelegate(((TypeMappingRegistryImpl)secondaryTMR).defaultDelTM);
        }
    }

    public javax.xml.rpc.encoding.TypeMapping register(String namespaceURI, javax.xml.rpc.encoding.TypeMapping mapping) {
        if (mapping == null || !(mapping instanceof TypeMapping)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullNamespaceURI"));
        }
        TypeMappingDelegate del = (TypeMappingDelegate)this.mapTM.get(namespaceURI);
        if (del == null) {
            del = new TypeMappingDelegate((TypeMapping)mapping);
            this.mapTM.put(namespaceURI, del);
            ((TypeMapping)mapping).setDelegate(this.defaultDelTM.getDelegate());
        } else {
            ((TypeMapping)mapping).setDelegate(del.getDelegate());
            del.setDelegate((TypeMapping)mapping);
        }
        return null;
    }

    public void registerDefault(javax.xml.rpc.encoding.TypeMapping mapping) {
        if (mapping == null || !(mapping instanceof TypeMapping)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (this.defaultDelTM.getDelegate() instanceof TypeMappingDelegate) {
            throw new IllegalArgumentException(Messages.getMessage("defaultTypeMappingSet"));
        }
        this.defaultDelTM.setDelegate((TypeMapping)mapping);
    }

    public javax.xml.rpc.encoding.TypeMapping getTypeMapping(String namespaceURI) {
        TypeMapping del = (TypeMapping)this.mapTM.get(namespaceURI);
        TypeMapping tm = null;
        if (del != null) {
            tm = del.getDelegate();
        }
        if (tm == null) {
            tm = (TypeMapping)this.getDefaultTypeMapping();
        }
        return tm;
    }

    public TypeMapping getOrMakeTypeMapping(String encodingStyle) {
        TypeMapping del = (TypeMapping)this.mapTM.get(encodingStyle);
        TypeMapping tm = null;
        if (del != null) {
            tm = del.getDelegate();
        }
        if (tm == null || tm instanceof DefaultTypeMappingImpl) {
            tm = (TypeMapping)this.createTypeMapping();
            tm.setSupportedEncodings(new String[]{encodingStyle});
            this.register(encodingStyle, tm);
        }
        return tm;
    }

    public javax.xml.rpc.encoding.TypeMapping unregisterTypeMapping(String namespaceURI) {
        TypeMapping del = (TypeMapping)this.mapTM.get(namespaceURI);
        TypeMapping tm = null;
        if (del != null) {
            tm = del.getDelegate();
            del.setDelegate(null);
        }
        return tm;
    }

    public boolean removeTypeMapping(javax.xml.rpc.encoding.TypeMapping mapping) {
        String[] ns = this.getRegisteredEncodingStyleURIs();
        boolean rc = false;
        int i = 0;
        while (i < ns.length) {
            if (this.getTypeMapping(ns[i]) == mapping) {
                rc = true;
                this.unregisterTypeMapping(ns[i]);
            }
            ++i;
        }
        return rc;
    }

    public javax.xml.rpc.encoding.TypeMapping createTypeMapping() {
        return new TypeMappingImpl(this.defaultDelTM);
    }

    public String[] getRegisteredEncodingStyleURIs() {
        Set s = this.mapTM.keySet();
        if (s != null) {
            String[] rc = new String[s.size()];
            int i = 0;
            Iterator it = s.iterator();
            while (it.hasNext()) {
                rc[i++] = (String)it.next();
            }
            return rc;
        }
        return null;
    }

    public void clear() {
        this.mapTM.clear();
    }

    public javax.xml.rpc.encoding.TypeMapping getDefaultTypeMapping() {
        TypeMapping defaultTM = this.defaultDelTM;
        while (defaultTM != null && defaultTM instanceof TypeMappingDelegate) {
            defaultTM = defaultTM.getDelegate();
        }
        return defaultTM;
    }
}

