/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.net.CommonsHTTPClientProperties;
import org.apache.axis.components.net.CommonsHTTPClientPropertiesFactory;
import org.apache.axis.components.net.TransportClientProperties;
import org.apache.axis.components.net.TransportClientPropertiesFactory;
import org.apache.axis.encoding.Base64;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;

public class CommonsHTTPSender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$transport$http$CommonsHTTPSender == null ? (class$org$apache$axis$transport$http$CommonsHTTPSender = CommonsHTTPSender.class$("org.apache.axis.transport.http.CommonsHTTPSender")) : class$org$apache$axis$transport$http$CommonsHTTPSender).getName());
    private HttpConnectionManager connectionManager;
    private CommonsHTTPClientProperties clientProperties;
    static /* synthetic */ Class class$org$apache$axis$transport$http$CommonsHTTPSender;

    public CommonsHTTPSender() {
        MultiThreadedHttpConnectionManager cm = new MultiThreadedHttpConnectionManager();
        this.clientProperties = CommonsHTTPClientPropertiesFactory.create();
        cm.setMaxConnectionsPerHost(this.clientProperties.getMaximumConnectionsPerHost());
        cm.setMaxTotalConnections(this.clientProperties.getMaximumTotalConnections());
        this.connectionManager = cm;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        HttpMethodBase method = null;
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("enter00", "CommonsHTTPSender::invoke"));
        }
        try {
            URL targetURL = new URL(msgContext.getStrProp("transport.url"));
            HttpClient httpClient = new HttpClient(this.connectionManager);
            httpClient.setHttpConnectionFactoryTimeout(this.clientProperties.getConnectionPoolTimeout());
            HostConfiguration hostConfiguration = this.getHostConfiguration(httpClient, targetURL);
            httpClient.setHostConfiguration(hostConfiguration);
            String webMethod = null;
            boolean posting = true;
            if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (webMethod = msgContext.getStrProp("soap12.webmethod")) != null) {
                posting = webMethod.equals("POST");
            }
            Message reqMessage = msgContext.getRequestMessage();
            if (posting) {
                method = new PostMethod(targetURL.toString());
                this.addContextInfo(method, httpClient, msgContext, targetURL);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                reqMessage.writeTo(baos);
                ((EntityEnclosingMethod)method).setRequestBody(new ByteArrayInputStream(baos.toByteArray()));
                ((PostMethod)method).setUseExpectHeader(false);
            } else {
                method = new GetMethod(targetURL.toString());
                this.addContextInfo(method, httpClient, msgContext, targetURL);
            }
            if (msgContext.getMaintainSession()) {
                int index;
                HttpState state = httpClient.getState();
                state.setCookiePolicy(0);
                String host = hostConfiguration.getHost();
                String path = targetURL.getPath();
                boolean secure = hostConfiguration.getProtocol().isSecure();
                String ck1 = (String)msgContext.getProperty("Cookie");
                String ck2 = (String)msgContext.getProperty("Cookie2");
                if (ck1 != null) {
                    index = ck1.indexOf(61);
                    state.addCookie(new Cookie(host, ck1.substring(0, index), ck1.substring(index + 1), path, null, secure));
                }
                if (ck2 != null) {
                    index = ck2.indexOf(61);
                    state.addCookie(new Cookie(host, ck2.substring(0, index), ck2.substring(index + 1), path, null, secure));
                }
                httpClient.setState(state);
            }
            int returnCode = httpClient.executeMethod(method);
            String contentType = null;
            String contentLocation = null;
            String contentLength = null;
            if (method.getResponseHeader("Content-Type") != null) {
                contentType = method.getResponseHeader("Content-Type").getValue();
            }
            if (method.getResponseHeader("Content-Location") != null) {
                contentLocation = method.getResponseHeader("Content-Location").getValue();
            }
            if (method.getResponseHeader("Content-Length") != null) {
                contentLength = method.getResponseHeader("Content-Length").getValue();
            }
            String string = contentType = null == contentType ? null : contentType.trim();
            if (!(returnCode > 199 && returnCode < 300 || msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || contentType != null && !contentType.equals("text/html") && returnCode > 499 && returnCode < 600)) {
                String statusMessage = method.getStatusText();
                AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                try {
                    fault.setFaultDetailString(Messages.getMessage("return01", "" + returnCode, method.getResponseBodyAsString()));
                    throw fault;
                }
                catch (Throwable throwable) {
                    Object var17_22 = null;
                    method.releaseConnection();
                    throw throwable;
                }
            }
            InputStream releaseConnectionOnCloseStream = this.createConnectionReleasingInputStream(method);
            Message outMsg = new Message(releaseConnectionOnCloseStream, false, contentType, contentLocation);
            Header[] responseHeaders = method.getResponseHeaders();
            MimeHeaders responseMimeHeaders = outMsg.getMimeHeaders();
            int i = 0;
            while (i < responseHeaders.length) {
                Header responseHeader = responseHeaders[i];
                responseMimeHeaders.addHeader(responseHeader.getName(), responseHeader.getValue());
                ++i;
            }
            outMsg.setMessageType("response");
            msgContext.setResponseMessage(outMsg);
            if (log.isDebugEnabled()) {
                if (null == contentLength) {
                    log.debug("\n" + Messages.getMessage("no00", "Content-Length"));
                }
                log.debug("\n" + Messages.getMessage("xmlRecd00"));
                log.debug("-----------------------------------------------");
                log.debug(outMsg.getSOAPPartAsString());
            }
            if (msgContext.getMaintainSession()) {
                Header[] headers = method.getResponseHeaders();
                int i2 = 0;
                while (i2 < headers.length) {
                    if (headers[i2].getName().equalsIgnoreCase("Set-Cookie")) {
                        msgContext.setProperty("Cookie", this.cleanupCookie(headers[i2].getValue()));
                    } else if (headers[i2].getName().equalsIgnoreCase("Set-Cookie2")) {
                        msgContext.setProperty("Cookie2", this.cleanupCookie(headers[i2].getValue()));
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            log.debug(e);
            throw AxisFault.makeFault(e);
        }
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("exit00", "CommonsHTTPSender::invoke"));
        }
    }

    private String cleanupCookie(String cookie) {
        int index = (cookie = cookie.trim()).indexOf(59);
        if (index != -1) {
            cookie = cookie.substring(0, index);
        }
        return cookie;
    }

    private HostConfiguration getHostConfiguration(HttpClient client, URL targetURL) {
        TransportClientProperties tcp = TransportClientPropertiesFactory.create(targetURL.getProtocol());
        int port = targetURL.getPort();
        boolean hostInNonProxyList = this.isHostInNonProxyList(targetURL.getHost(), tcp.getNonProxyHosts());
        HostConfiguration config = new HostConfiguration();
        if (port == -1) {
            port = 80;
        }
        if (hostInNonProxyList) {
            config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        } else if (tcp.getProxyHost().length() == 0 || tcp.getProxyPort().length() == 0) {
            config.setHost(targetURL.getHost(), port, targetURL.getProtocol());
        } else {
            if (tcp.getProxyUser().length() != 0) {
                UsernamePasswordCredentials proxyCred = new UsernamePasswordCredentials(tcp.getProxyUser(), tcp.getProxyPassword());
                client.getState().setProxyCredentials(null, null, proxyCred);
            }
            int proxyPort = new Integer(tcp.getProxyPort());
            config.setProxy(tcp.getProxyHost(), proxyPort);
        }
        return config;
    }

    private void addContextInfo(HttpMethodBase method, HttpClient httpClient, MessageContext msgContext, URL tmpURL) throws Exception {
        Hashtable userHeaderTable;
        MimeHeaders mimeHeaders;
        Message msg;
        String action;
        if (msgContext.getTimeout() != 0) {
            httpClient.setTimeout(msgContext.getTimeout());
            httpClient.setConnectionTimeout(msgContext.getTimeout());
        }
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if ((msg = msgContext.getRequestMessage()) != null) {
            method.setRequestHeader(new Header("Content-Type", msg.getContentType(msgContext.getSOAPConstants())));
        }
        method.setRequestHeader(new Header("SOAPAction", "\"" + action + "\""));
        String userID = msgContext.getUsername();
        String passwd = msgContext.getPassword();
        if (userID == null && tmpURL.getUserInfo() != null) {
            String info = tmpURL.getUserInfo();
            int sep = info.indexOf(58);
            if (sep >= 0 && sep + 1 < info.length()) {
                userID = info.substring(0, sep);
                passwd = info.substring(sep + 1);
            } else {
                userID = info;
            }
        }
        if (userID != null) {
            UsernamePasswordCredentials cred = new UsernamePasswordCredentials(userID, passwd);
            httpClient.getState().setCredentials(null, null, cred);
            StringBuffer tmpBuf = new StringBuffer();
            tmpBuf.append(userID).append(":").append(passwd == null ? "" : passwd);
            method.addRequestHeader("Authorization", "Basic " + Base64.encode(tmpBuf.toString().getBytes()));
        }
        if ((mimeHeaders = msg.getMimeHeaders()) != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                method.addRequestHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            Iterator e = userHeaderTable.entrySet().iterator();
            while (e.hasNext()) {
                Map.Entry me = e.next();
                Object keyObj = me.getKey();
                if (null == keyObj) continue;
                String key = keyObj.toString().trim();
                String value = me.getValue().toString().trim();
                method.addRequestHeader(key, value);
            }
        }
    }

    protected boolean isHostInNonProxyList(String host, String nonProxyHosts) {
        if (nonProxyHosts == null || host == null) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|\"");
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("match00", new String[]{"HTTPSender", host, pattern}));
            }
            if (!CommonsHTTPSender.match(pattern, host, false)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (isCaseSensitive && ch != strArr[i]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl36
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxStart]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
lbl36:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl37:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl51
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                return false;
            }
            if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl51:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl52:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl92
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block27: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (!(isCaseSensitive && ch != strArr[strIdxStart + i + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block27;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl92:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl93:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private InputStream createConnectionReleasingInputStream(final HttpMethodBase method) throws IOException {
        return new FilterInputStream(method.getResponseBodyAsStream()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                try {
                    super.close();
                    Object var2_1 = null;
                    method.releaseConnection();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    method.releaseConnection();
                    throw throwable;
                }
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

