/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCEncodeException;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFactory;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.ale.epc.NumberUtil;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import com.connecterra.util.ConfigItem;
import com.connecterra.util.ConfigItemException;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.StringConfigItem;
import com.connecterra.util.ValidatedConfig;
import java.math.BigInteger;
import java.net.URI;

public abstract class EPC {
    private static TDSVersion d;
    protected static final BigInteger MASK_64;
    private long[] b;
    private URI i;
    private URI h;
    private URI c;
    private URI e;
    private EPCImpl f;
    private BigInteger g = null;

    public static void initialize(RawConfig rawConfig) throws ConfigValidationException {
        ValidatedConfig validatedConfig = new ValidatedConfig();
        StringConfigItem stringConfigItem = new StringConfigItem();
        validatedConfig.addItem("tagDataStandardVersion", (ConfigItem)stringConfigItem, null);
        validatedConfig.readFrom(rawConfig);
        if (stringConfigItem.isValid()) {
            try {
                EPC.setTDSVersion(stringConfigItem.stringValue());
            }
            catch (EPCException ePCException) {
                ConfigValidationException configValidationException = new ConfigValidationException();
                configValidationException.add(new ConfigItemException(ePCException.getMessage(), ePCException));
                throw configValidationException;
            }
        }
    }

    public static EPC createInstance(URI uRI) {
        EPC ePC = null;
        try {
            ePC = EPCFactory.getInstance().create(uRI);
        }
        catch (EPCException ePCException) {
            ePCException.printStackTrace();
        }
        return ePC;
    }

    public static EPC createInstance(long l, long l2) {
        EPC ePC = null;
        try {
            ePC = EPCFactory.getInstance().create(l, l2);
        }
        catch (EPCException ePCException) {
            ePCException.printStackTrace();
        }
        return ePC;
    }

    protected EPC() {
    }

    protected EPC(EPCImpl ePCImpl) {
        this.f = ePCImpl;
    }

    public abstract Scheme getScheme();

    public final String getTypeString() {
        return this.getScheme().getTypeString();
    }

    protected void validate() throws EPCValidationException, EPCException {
        this.getScheme().validate(this);
    }

    public int getBitSize() {
        return this.getScheme().getEPCDescriptor().getBitSize();
    }

    public int getHeader() {
        return this.getScheme().getEPCDescriptor().getHeader();
    }

    public URI getURI() {
        URI uRI = null;
        try {
            uRI = this.getTagURI();
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return uRI;
    }

    public String getHex() throws EPCEncodeException {
        String string = null;
        try {
            URI uRI = this.getRawHexURI();
            string = uRI.toString();
            int n = string.lastIndexOf("x");
            if (n <= 0) {
                throw new EPCEncodeException(I18N.get("unable to generate Hex Value"));
            }
            string = string.substring(n + 1);
        }
        catch (EPCException ePCException) {
            throw new EPCEncodeException(ePCException.getMessage(), ePCException);
        }
        return string;
    }

    public URI getTagURI() throws EPCException {
        if (this.c == null) {
            this.c = this.getScheme().getTagURIEncoder().encode(this);
        }
        return this.c;
    }

    public URI getCanonicalURI() {
        URI uRI = null;
        try {
            uRI = this.getPureIdentityURI();
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return uRI;
    }

    public URI getPureIdentityURI() throws EPCException {
        if (this.e == null) {
            this.e = this.getScheme().getPureIdentityURIEncoder().encode(this);
        }
        return this.e;
    }

    public URI getRawHexURI() throws EPCException {
        if (this.h == null) {
            this.h = this.getScheme().getRawHexEncoder().encode(this);
        }
        return this.h;
    }

    public URI getRawDecimalURI() throws EPCException {
        if (this.i == null) {
            this.i = this.getScheme().getRawDecimalEncoder().encode(this);
        }
        return this.i;
    }

    protected void setLongArray(long[] lArray) {
        this.b = lArray;
    }

    public long[] getLongArray() throws EPCException {
        if (this.b == null) {
            this.b = this.getScheme().getBinaryEncoder().encode(this);
        }
        return this.b;
    }

    public long getHiValue() throws EPCException {
        long[] lArray = this.getLongArray();
        return lArray[0];
    }

    public long getLowValue() throws EPCException {
        long[] lArray = this.getLongArray();
        return lArray.length > 1 ? lArray[1] : 0L;
    }

    public static void setTDSVersion(String string) throws EPCException {
        d = TDSVersion.fromString(string);
    }

    public static TDSVersion getTDSVersion() {
        return d;
    }

    protected void setBigInteger(BigInteger bigInteger) throws EPCException {
        if (this.g == null) {
            this.g = bigInteger;
        } else if (this.g.compareTo(bigInteger) != 0) {
            throw new EPCException("attempting to set big int representation with a differnt value; old = " + this.g + ", new = " + bigInteger);
        }
    }

    protected BigInteger getBigInteger() throws EPCException {
        if (this.g == null) {
            switch (this.getBitSize()) {
                case 64: 
                case 96: 
                case 128: {
                    long[] lArray = this.getLongArray();
                    BigInteger bigInteger = NumberUtil.MASK_64.and(BigInteger.valueOf(lArray[0]));
                    BigInteger bigInteger2 = NumberUtil.MASK_64.and(BigInteger.valueOf(lArray[1]));
                    this.g = bigInteger.shiftLeft(64).or(bigInteger2);
                    break;
                }
                default: {
                    throw new EPCException("bit size not supported: " + this.getBitSize());
                }
            }
        }
        return this.g;
    }

    protected EPCImpl getEPCImpl() throws EPCException {
        if (this.f == null) {
            this.f = new EPCImpl(this.getScheme());
        }
        return this.f;
    }

    protected EPCField getEPCField(int n) throws EPCException, IndexOutOfBoundsException {
        return this.getEPCImpl().getField(n);
    }

    protected void setFieldInteger(int n, int n2) throws EPCException {
        EPCField ePCField = this.getEPCField(n);
        ((EPCFieldNumeric)ePCField).setValue(n2);
    }

    protected int getFieldInteger(int n) throws EPCException {
        EPCField ePCField = this.getEPCField(n);
        return (int)((EPCFieldNumeric)ePCField).getValue();
    }

    protected long getFieldLong(int n) throws EPCException {
        EPCField ePCField = this.getEPCField(n);
        return ((EPCFieldNumeric)ePCField).getValue();
    }

    protected void setFieldLong(int n, long l) throws EPCException {
        EPCField ePCField = this.getEPCField(n);
        ((EPCFieldNumeric)ePCField).setValue(l);
    }

    protected String getFieldString(int n) throws EPCException {
        EPCField ePCField = this.getEPCField(n);
        return ((EPCFieldString)ePCField).getValue();
    }

    protected void setFieldString(int n, String string) throws EPCException {
        EPCField ePCField = this.getEPCField(n);
        ((EPCFieldString)ePCField).setValue(string);
    }

    public String dump() throws EPCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EPC Scheme:           " + this.getScheme().getEPCDescriptor().getDescription() + "\n");
        stringBuffer.append("  Pure Identity URI:  " + this.getPureIdentityURI().toASCIIString() + "\n");
        stringBuffer.append("  Tag URI:            " + this.getTagURI().toASCIIString() + "\n");
        stringBuffer.append("  RawHex URI:         " + this.getRawHexURI().toASCIIString() + "\n");
        stringBuffer.append("  RawDecimal URI:     " + this.getRawDecimalURI().toASCIIString() + "\n");
        stringBuffer.append("  Hex:                " + this.getRawHexURI().toASCIIString() + "\n");
        long[] lArray = this.getLongArray();
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append("  long[" + i + "]:    " + lArray[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "";
        try {
            string = this.getTagURI().toASCIIString();
        }
        catch (EPCException ePCException) {
            string = ePCException.getMessage();
        }
        return string;
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof EPC) {
            EPC ePC = (EPC)object;
            if (this.getScheme().equals(ePC.getScheme())) {
                try {
                    int n = this.getEPCImpl().getEPCDescriptor().getFieldDescriptorCount();
                    bl = true;
                    for (int i = 0; bl && i < n; ++i) {
                        bl = this.getEPCField(i).equals(this.getEPCField(i));
                    }
                }
                catch (EPCException ePCException) {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public final EncodedEPC encode(EncodedEPC encodedEPC) throws EPCEncodeException {
        if (encodedEPC == null) {
            encodedEPC = new EncodedEPC();
        }
        try {
            encodedEPC.hiVal = this.getHiValue();
            encodedEPC.lowVal = this.getLowValue();
        }
        catch (EPCException ePCException) {
            throw new EPCEncodeException(ePCException.getMessage(), ePCException);
        }
        return encodedEPC;
    }

    static {
        MASK_64 = NumberUtil.MASK_64;
    }

    public static class EncodedEPC {
        public long hiVal = 0L;
        public long lowVal = 0L;
    }
}

