/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldConstraint;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.i18n.I18N;

public class EPCFieldConstraintMinMax
extends EPCFieldConstraint {
    private final long c;
    private final long d;

    public EPCFieldConstraintMinMax(String string, long l, long l2) {
        super(string);
        this.c = l;
        this.d = l2;
    }

    public long getMinimumValue() {
        return this.c;
    }

    public long getMaximumValue() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n  Min: " + this.getMinimumValue());
        stringBuffer.append("\n  Max: " + this.getMaximumValue());
        return stringBuffer.toString();
    }

    protected void validate(EPCField ePCField) throws EPCValidationException {
        switch (ePCField.getEPCFieldDescriptor().getType()) {
            case 2: {
                long l = ((EPCFieldNumeric)ePCField).getValue();
                if (l <= this.getMaximumValue() && l >= this.getMinimumValue()) break;
                throw new EPCValidationException(I18N.get("min max constraint of ( {0} - {1} ) not satisfied for field {2} with value {3}", new String[]{String.valueOf(this.getMinimumValue()), String.valueOf(this.getMaximumValue()), ePCField.getEPCFieldDescriptor().getName(), String.valueOf(l)}));
            }
            case 1: {
                throw new EPCValidationException(I18N.get("type String not appropriate for min max constraint "));
            }
            default: {
                throw new EPCValidationException(I18N.get("unknown field type: {0} for field {1} for min max constraint", ePCField.getEPCFieldDescriptor().getType(), (Object)ePCField.getEPCFieldDescriptor().getName()));
            }
        }
    }
}

