/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCImpl;

public class EPCFieldEncoderBarcode
extends EPCFieldEncoderNumeric {
    private int m;
    private int n;

    public EPCFieldEncoderBarcode(int n, int n2, int n3, int n4) {
        super(n, n2, 10);
        this.n = n3;
        this.m = n4;
    }

    public String encode(EPCImpl ePCImpl, EPCField ePCField) throws EPCFieldEncodingException, EPCException {
        EPCField ePCField2 = ePCImpl.getField(this.m);
        int n = (int)((EPCFieldNumeric)ePCField2).getValue();
        ((EPCFieldNumeric)ePCField).setSize(n);
        EPCField ePCField3 = ePCImpl.getField(this.n);
        long l = ((EPCFieldNumeric)ePCField3).getValue();
        if (l == 0L) {
            this.setRadix(10);
        } else if (l == 1L) {
            this.setRadix(36);
        } else {
            throw new EPCException("radix has unexpected value " + l);
        }
        return super.encode(ePCImpl, ePCField).toUpperCase();
    }

    public void decode(EPCImpl ePCImpl, EPCField ePCField, String string) throws EPCFieldDecodingException, EPCException {
        int n = string.length();
        EPCField ePCField2 = ePCImpl.getField(this.m);
        ((EPCFieldNumeric)ePCField2).setValue(n);
        ((EPCFieldNumeric)ePCField).setSize(n);
        EPCFieldNumeric ePCFieldNumeric = (EPCFieldNumeric)ePCImpl.getField(this.n);
        try {
            Long.parseLong(string);
            ePCFieldNumeric.setValue(0L);
            this.setRadix(10);
        }
        catch (NumberFormatException numberFormatException) {
            ePCFieldNumeric.setValue(1L);
            this.setRadix(36);
        }
        super.decode(ePCImpl, ePCField, string);
    }
}

