/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternField;
import com.connecterra.ale.epc.EPCPatternFieldNumeric;
import com.connecterra.ale.epc.EPCPatternFieldString;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;

public class EPCPatternImpl
extends EPCImpl {
    EPCPatternImpl(Scheme scheme) throws EPCException, EPCPatternException {
        super(scheme);
    }

    protected ArrayList createFieldList() throws EPCException {
        ArrayList<EPCPatternField> arrayList = new ArrayList<EPCPatternField>();
        ArrayList arrayList2 = this.getEPCDescriptor().getEPCFieldDescriptorList();
        for (EPCFieldDescriptor ePCFieldDescriptor : arrayList2) {
            if (ePCFieldDescriptor.getType() == 2) {
                arrayList.add(new EPCPatternFieldNumeric(ePCFieldDescriptor));
                continue;
            }
            if (ePCFieldDescriptor.getType() == 1) {
                arrayList.add(new EPCPatternFieldString(ePCFieldDescriptor));
                continue;
            }
            throw new EPCPatternException(I18N.get("unsupported EPCFieldDescriptor type {0}", ePCFieldDescriptor.getClass()));
        }
        return arrayList;
    }

    public EPCPatternField getPatternField(int n) throws EPCException {
        return (EPCPatternField)super.getField(n);
    }

    public EPCField getField(int n) throws EPCException {
        return this.getPatternField(n).getEPCField();
    }
}

