/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverterForCompanyPrefixIndex;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefix;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.GIAI64;
import com.connecterra.ale.epc.GIAI64Pattern;
import com.connecterra.ale.epc.GIAIScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class GIAI64Scheme
extends GIAIScheme {
    private final int ue = 11;
    private final int re = 8;
    private final int ve = 3;
    private final int se = 14;
    private final int xe = 39;
    private final int ye = 64;
    private final int te = 72;
    private final int ze = 75;
    private final int we = 89;

    protected GIAI64Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new GIAI64(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new GIAI64Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("Global Individual Asset Identifier (GIAI-64)"), 11, Scheme.GIAI_64, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(4);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("GIAI-64 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("GIAI-64 Header constraint"), 11L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("GIAI-64 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GIAI-64 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 14, I18N.get("Company Prefix"), I18N.get("GIAI-64 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("GIAI-64 Company Prefix constraint"), "[0-9]+", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 39, I18N.get("Individual Asset Reference"), I18N.get("GIAI-64 Individual Asset Reference"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GIAI-64 Individual Asset Reference constraint"), 0L, (long)Math.pow(2.0, 39.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:giai-64:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 1, 2));
        arrayList.add(new EPCFieldEncoderNumeric(2, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:giai:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 0, 2));
        arrayList.add(new EPCFieldEncoderNumeric(1, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:giai-64:";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, ".", list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 72, 3));
        arrayList.add(new EPCBinaryFieldEncoder(2, 75, 14, new BinaryConverterForCompanyPrefixIndex(this)));
        arrayList.add(new EPCBinaryFieldEncoder(3, 89, 39));
        return new EPCBinaryEncoder(this, 11, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
    }
}

