/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryCompanyPrefixAndComplimentFieldEncoder;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.ale.epc.GIAI96;
import com.connecterra.ale.epc.GIAI96Pattern;
import com.connecterra.ale.epc.GIAIScheme;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class GIAI96Scheme
extends GIAIScheme {
    private final int he = 52;
    private static int[][] me = new int[][]{{0, 40, 12, 42, 12}, {1, 37, 11, 45, 13}, {2, 34, 10, 48, 14}, {3, 30, 9, 52, 15}, {4, 27, 8, 55, 16}, {5, 24, 7, 58, 17}, {6, 20, 6, 62, 18}};
    private static final PartitionTable pe = new PartitionTable(me);
    private final int ee = 8;
    private final int ke = 3;
    private final int oe = 3;
    private final int je = 40;
    private final int ie = 62;
    private final int qe = 82;
    private final int ne = 32;
    private final int ge = 40;
    private final int fe = 43;
    private final int le = 46;

    protected GIAI96Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new GIAI96(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new GIAI96Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(96, I18N.get("Global Individual Asset Identifier (GIAI-96)"), 52, Scheme.GIAI_96, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(4);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("GIAI-96 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("GIAI-96 Header constraint"), 52L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("GIAI-96 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GIAI-96 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 40, I18N.get("Company Prefix"), I18N.get("GIAI-96 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("GIAI-96 Company Prefix constraint"), "[0-9]+", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 62, I18N.get("Individual Asset Reference"), I18N.get("GIAI-96 Individual Asset Reference"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("GIAI-96 Individual Asset Reference constraint"), 0L, (long)Math.pow(2.0, 62.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:giai-96:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderString(1, 2, 6, 12));
        arrayList.add(new EPCFieldEncoderNumeric(2, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:giai:";
        String string2 = ".";
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 6, 12));
        arrayList.add(new EPCFieldEncoderNumeric(1, 3, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:giai-96:";
        String string2 = ".";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, string2, list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 32, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 40, 3));
        arrayList.add(new EPCBinaryCompanyPrefixAndComplimentFieldEncoder(2, 3, 43, 3, 82, pe));
        return new EPCBinaryEncoder(this, 52, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException, EPCValidationException {
        this.interFieldValidationWithPartitionTable(ePC, pe, 2, 3, false);
    }
}

