/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCIDPattern;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternFactory;
import com.connecterra.ale.epc.GIAIPattern;

public class GIAIIDPattern
extends EPCIDPattern {
    GIAIIDPattern(EPCPattern ePCPattern) {
        super(ePCPattern);
    }

    public String getTypeString() {
        return "giai";
    }

    public EPCPattern getEPCPattern(int n, int n2) {
        GIAIPattern gIAIPattern = null;
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("Incorrect Filter Value: " + n2);
        }
        try {
            if (n == 64) {
                gIAIPattern = EPCPatternFactory.getInstance().createGIAI64Pattern();
            } else if (n == 96) {
                gIAIPattern = EPCPatternFactory.getInstance().createGIAI96Pattern();
            } else {
                throw new IllegalArgumentException("Incorrect tag length: " + n);
            }
            if (gIAIPattern != null) {
                gIAIPattern.assign(this.getEPCPattern());
                gIAIPattern.getFilter().setValue(n2);
            }
        }
        catch (EPCException ePCException) {
            throw new IllegalStateException(ePCException.getMessage());
        }
        return gIAIPattern;
    }
}

