/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.i18n.I18N;

class PartitionTable {
    private final int[][] b;

    public PartitionTable(int[][] nArray) {
        this.b = nArray;
    }

    public int getValue(int n, int n2) {
        return this.b[n][n2];
    }

    public int getRows() {
        return this.b.length;
    }

    public int getPartionValue(int n) {
        return this.getValue(n, 0);
    }

    public int getCompanyPrefixBits(int n) {
        return this.getValue(n, 1);
    }

    public int getCompanyPrefixDigits(int n) {
        return this.getValue(n, 2);
    }

    public int getComplimentBits(int n) {
        return this.getValue(n, 3);
    }

    public int getComplimentDigits(int n) {
        return this.getValue(n, 4);
    }

    public int getRowForCompanyPrefix(String string) throws EPCException {
        int n = string.length();
        int n2 = -1;
        for (int i = 0; n2 < 0 && i < this.getRows(); ++i) {
            if (this.getCompanyPrefixDigits(i) != n) continue;
            n2 = i;
        }
        if (n2 < 0) {
            throw new EPCException(I18N.get("Company Prefix {0} has a non valid length of {1}", (Object)string, n));
        }
        return n2;
    }

    public static interface Column {
        public static final int PARTITION_VALUE = 0;
        public static final int COMPANY_PREFIX_BITS = 1;
        public static final int COMPANY_PREFIX_DIGITS = 2;
        public static final int COMPLIMENT_BITS = 3;
        public static final int COMPLIMENT_DIGITS = 4;
    }
}

