/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverterForCompanyPrefixIndex;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefix;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.SGLN64;
import com.connecterra.ale.epc.SGLN64Pattern;
import com.connecterra.ale.epc.SGLNScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class SGLN64Scheme
extends SGLNScheme {
    private final int wh = 9;
    private static final int sh = 12;
    private final int ph = 8;
    private final int xh = 3;
    private final int rh = 14;
    private final int th = 20;
    private final int vh = 19;
    private final int zh = 64;
    private final int uh = 72;
    private final int ai = 75;
    private final int qh = 89;
    private final int yh = 109;

    protected SGLN64Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new SGLN64(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new SGLN64Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("Serialized Global Location Number (SGLN-64)"), 9, Scheme.SGLN_64, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("SGLN-64 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("SGLN-64 Header constraint"), 9L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("SGLN-64 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGLN-64 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 14, I18N.get("Company Prefix"), I18N.get("SGLN-64 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("SGLN-64 Company Prefix constraint"), "[0-9]*", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 20, I18N.get("Location Reference"), I18N.get("SGLN-64 Location Reference"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGLN-64 Location Reference constraint"), 0L, (long)Math.pow(2.0, 20.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 19, I18N.get("Serial Number"), I18N.get("SGLN-64 Serial Number"), 4, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGLN-64 Serial Number constraint"), 0L, (long)Math.pow(2.0, 19.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:sgln-64:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 1, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 2, 2, 3, 12));
        arrayList.add(new EPCFieldEncoderNumeric(3, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:sgln:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 0, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 1, 2, 3, 12));
        arrayList.add(new EPCFieldEncoderNumeric(2, 4, 10, false, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:sgln-64:";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, ".", list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 72, 3));
        arrayList.add(new EPCBinaryFieldEncoder(2, 75, 14, new BinaryConverterForCompanyPrefixIndex(this)));
        arrayList.add(new EPCBinaryFieldEncoder(3, 89, 20));
        arrayList.add(new EPCBinaryFieldEncoder(4, 109, 19));
        return new EPCBinaryEncoder(this, 9, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        SGLN64 sGLN64 = (SGLN64)ePC;
        String string = sGLN64.getCompanyPrefix();
        long l = sGLN64.getLocationReference();
        this.interFieldValidationForGS1_64(12, string, l);
    }
}

