/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryCompanyPrefixAndComplimentFieldEncoder;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder96bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.ale.epc.SGLN96;
import com.connecterra.ale.epc.SGLN96Pattern;
import com.connecterra.ale.epc.SGLNScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class SGLN96Scheme
extends SGLNScheme {
    private final int fh = 50;
    private static int[][] kh = new int[][]{{0, 40, 12, 1, 0}, {1, 37, 11, 4, 1}, {2, 34, 10, 7, 2}, {3, 30, 9, 11, 3}, {4, 27, 8, 14, 4}, {5, 24, 7, 17, 5}, {6, 20, 6, 21, 6}};
    private static final PartitionTable nh = new PartitionTable(kh);
    private final int mh = 32;
    private final int ah = 8;
    private final int ch = 40;
    private final int hh = 3;
    private final int bh = 43;
    private final int lh = 3;
    private final int jh = 46;
    private final int gh = 40;
    private final int eh = 21;
    private final int oh = 41;
    private final int ih = 87;
    private final int dh = 41;

    protected SGLN96Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new SGLN96(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new SGLN96Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(96, I18N.get("Serialized Global Location Number (SGLN-96)"), 50, Scheme.SGLN_96, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("SGLN-96 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("SGLN-96 Header constraint"), 50L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("SGLN-96 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGLN-96 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 40, I18N.get("Company Prefix"), I18N.get("SGLN-96 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("SGLN-96 Company Prefix constraint"), "[0-9]*", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 21, I18N.get("Location Reference"), I18N.get("SGLN-96 Location Reference"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGLN-96 Location Reference constraint"), 0L, (long)Math.pow(2.0, 21.0) - 1L)));
        arrayList.add(new EPCFieldDescriptor(2, 41, I18N.get("Serial Number"), I18N.get("SGLN-96 Serial Number"), 4, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGLN-96 Serial Number constraint"), 0L, (long)Math.pow(2.0, 41.0) - 1L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:sgln-96:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderString(1, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 2, 2, 3, nh));
        arrayList.add(new EPCFieldEncoderNumeric(3, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:sgln:";
        String string2 = ".";
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 1, 2, 3, nh));
        arrayList.add(new EPCFieldEncoderNumeric(2, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:sgln-96:";
        String string2 = ".";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, string2, list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 32, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 40, 3));
        arrayList.add(new EPCBinaryCompanyPrefixAndComplimentFieldEncoder(2, 3, 43, 3, 41, nh));
        arrayList.add(new EPCBinaryFieldEncoder(4, 87, 41));
        return new EPCBinaryEncoder(this, 50, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        this.interFieldValidationWithPartitionTable(ePC, nh, 2, 3);
    }
}

