/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryCompanyPrefixAndComplimentFieldEncoder;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder96bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncoderString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.ale.epc.SSCC96;
import com.connecterra.ale.epc.SSCC96Pattern;
import com.connecterra.ale.epc.SSCCScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SSCC96Scheme
extends SSCCScheme {
    private final int ef = 49;
    private final int bf = 8;
    private final int ff = 3;
    private final int jf = 3;
    private final int mf = 58;
    private final int gf = 24;
    private final int kf = 32;
    private final int df = 40;
    private final int cf = 43;
    private final int if = 46;
    private final int af = 104;
    private static int[][] hf = new int[][]{{0, 40, 12, 18, 5}, {1, 37, 11, 21, 6}, {2, 34, 10, 24, 7}, {3, 30, 9, 28, 8}, {4, 27, 8, 31, 9}, {5, 24, 7, 34, 10}, {6, 20, 6, 38, 11}};
    private static final PartitionTable lf = new PartitionTable(hf);

    protected SSCC96Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new SSCC96(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new SSCC96Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(96, I18N.get("Serial Shipping Container Code (SSCC-96)"), 49, Scheme.SSCC_96, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>();
        arrayList.add(new EPCFieldDescriptor(2, 8, I18N.get("Header"), I18N.get("SSCC-96 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("SSCC-96 Header constraint"), 49L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("SSCC-96 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SSCC-96 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 40, I18N.get("Company Prefix"), I18N.get("SSCC-96 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("SSCC-96 Company Prefix constraint"), "[0-9]+", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 24, I18N.get("Serial Reference"), I18N.get("SSCC-96 Serial Reference"), 3, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SSCC-96 Serial Reference constraint"), 0L, 99999999999L)));
        arrayList.add(new EPCFieldDescriptor(2, 24, I18N.get("unallocated"), I18N.get("SSCC-96 unallocated"), 4, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("SSCC-96 unallocated constraint"), 0L)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:sscc-96:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoderString(1, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 2, 2, 3, lf));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:sscc:";
        String string2 = ".";
        Object var3_3 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderString(0, 2, 6, 12));
        arrayList.add(new EPCFieldEncoder96bitCompanyPrefixCompliment(this, 1, 2, 3, lf));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, string2, arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:sscc-96:";
        String string2 = ".";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, string2, list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 32, 8));
        arrayList.add(new EPCBinaryFieldEncoder(1, 40, 3));
        arrayList.add(new EPCBinaryCompanyPrefixAndComplimentFieldEncoder(2, 3, 43, 3, 58, lf));
        arrayList.add(new EPCBinaryFieldEncoder(4, 104, 24));
        return new EPCBinaryEncoder(this, 49, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        this.interFieldValidationWithPartitionTable(ePC, lf, 2, 3);
    }
}

