/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epchelpers;

import com.connecterra.i18n.I18N;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompanyPrefixTable {
    private static Logger b = Logger.getLogger("com.connecterra.ale.epchelpers.CompanyPrefixTable");
    private static Map d = Collections.synchronizedMap(new HashMap());
    private static Map c = Collections.synchronizedMap(new HashMap());

    public static TableEntry getCompanyPrefix(int n) {
        return (TableEntry)d.get(new Integer(n));
    }

    public static TableEntry getCompanyPrefix(String string) {
        return (TableEntry)c.get(string);
    }

    public static void addEntry(int n, String string) {
        TableEntry tableEntry;
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Cannot insert a null prefix"));
        }
        try {
            tableEntry = new TableEntry(string.length(), Long.parseLong(string), n);
        }
        catch (NumberFormatException numberFormatException) {
            b.log(Level.FINE, "entry value \"" + string + "\" is invalid: " + numberFormatException, numberFormatException);
            return;
        }
        Integer n2 = new Integer(n);
        d.put(n2, tableEntry);
        c.put(string, tableEntry);
    }

    public static class TableEntry {
        private long d = 0L;
        private int c = 0;
        private int e = 0;
        private static final String b = "000000000000000";

        private TableEntry(int n, long l, int n2) {
            this.c = n;
            this.d = l;
            this.e = n2;
        }

        public int getLength() {
            return this.c;
        }

        public long getPrefix() {
            return this.d;
        }

        public int getIndex() {
            return this.e;
        }

        public String getPrefixAsString() {
            String string = String.valueOf(this.getPrefix());
            int n = this.getLength() - string.length();
            if (n > 0) {
                string = b.substring(0, n) + string;
            }
            return string;
        }
    }
}

