/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.axis.adapters;

import com.connecterra.alepc.api.EPCCacheSpecInfo;
import com.connecterra.alepc.axis.adapters.EPCPatternsAdapter;
import com.connecterra.alepc.axis.schema.EPCPatterns;
import com.connecterra.alepc.axis.schema.PCSpecs;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class EPCCacheSpecInfoAdapter
implements EPCCacheSpecInfo {
    private com.connecterra.alepc.axis.schema.EPCCacheSpecInfo b;

    public static com.connecterra.alepc.axis.schema.EPCCacheSpecInfo aleToAxis(EPCCacheSpecInfo ePCCacheSpecInfo) {
        if (ePCCacheSpecInfo == null) {
            return null;
        }
        if (ePCCacheSpecInfo instanceof EPCCacheSpecInfoAdapter) {
            return ((EPCCacheSpecInfoAdapter)ePCCacheSpecInfo).getAxisEPCCacheSpecInfo();
        }
        return new EPCCacheSpecInfoAdapter(ePCCacheSpecInfo).getAxisEPCCacheSpecInfo();
    }

    public static EPCCacheSpecInfo axisToALE(com.connecterra.alepc.axis.schema.EPCCacheSpecInfo ePCCacheSpecInfo) throws URISyntaxException {
        return ePCCacheSpecInfo == null ? null : new EPCCacheSpecInfoAdapter(ePCCacheSpecInfo);
    }

    EPCCacheSpecInfoAdapter(EPCCacheSpecInfo ePCCacheSpecInfo) {
        Object object;
        this.b = new com.connecterra.alepc.axis.schema.EPCCacheSpecInfo();
        this.b.setSubscriberCount(ePCCacheSpecInfo.getSubscriberCount());
        List list = ePCCacheSpecInfo.getPCSpecNames();
        if (list != null) {
            object = new PCSpecs();
            ((PCSpecs)object).setPcSpec(list.toArray(new String[list.size()]));
            this.b.setPcSpecs((PCSpecs)object);
        }
        this.b.setActivationCount(ePCCacheSpecInfo.getActivationCount());
        if (ePCCacheSpecInfo.getLastActivated() != -1L) {
            object = Calendar.getInstance();
            ((Calendar)object).setTimeInMillis(ePCCacheSpecInfo.getLastActivated());
            this.b.setLastActivated((Calendar)object);
        }
        this.b.setReplenishCount(ePCCacheSpecInfo.getReplenishCount());
        if (ePCCacheSpecInfo.getLastReplenished() != -1L) {
            object = Calendar.getInstance();
            ((Calendar)object).setTimeInMillis(ePCCacheSpecInfo.getLastReplenished());
            this.b.setLastReplenished((Calendar)object);
        }
        if (ePCCacheSpecInfo.getLastReported() != -1L) {
            object = Calendar.getInstance();
            ((Calendar)object).setTimeInMillis(ePCCacheSpecInfo.getLastReported());
            this.b.setLastReported((Calendar)object);
        }
        this.b.setCacheSize(ePCCacheSpecInfo.getCacheSize());
        object = ePCCacheSpecInfo.getCacheContent();
        this.b.setCacheContent(EPCPatternsAdapter.aleToAxis((com.connecterra.alepc.api.EPCPatterns)object));
    }

    public EPCCacheSpecInfoAdapter() {
        this.b = new com.connecterra.alepc.axis.schema.EPCCacheSpecInfo();
    }

    private EPCCacheSpecInfoAdapter(com.connecterra.alepc.axis.schema.EPCCacheSpecInfo ePCCacheSpecInfo) throws URISyntaxException {
        this.b = ePCCacheSpecInfo;
        EPCPatterns ePCPatterns = this.b.getCacheContent();
        EPCPatternsAdapter.axisToALE(ePCPatterns);
    }

    public com.connecterra.alepc.axis.schema.EPCCacheSpecInfo getAxisEPCCacheSpecInfo() {
        return this.b;
    }

    public int getSubscriberCount() {
        return this.b.getSubscriberCount();
    }

    public List getPCSpecNames() {
        PCSpecs pCSpecs = this.b.getPcSpecs();
        if (pCSpecs == null || pCSpecs.getPcSpec() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(pCSpecs.getPcSpec()));
    }

    public int getActivationCount() {
        return this.b.getActivationCount();
    }

    public long getLastActivated() {
        return this.b.getLastActivated() == null ? -1L : this.b.getLastActivated().getTimeInMillis();
    }

    public int getReplenishCount() {
        return this.b.getReplenishCount();
    }

    public long getLastReplenished() {
        return this.b.getLastReplenished() == null ? -1L : this.b.getLastReplenished().getTimeInMillis();
    }

    public long getLastReported() {
        return this.b.getLastReported() == null ? -1L : this.b.getLastReported().getTimeInMillis();
    }

    public long getCacheSize() {
        return this.b.getCacheSize();
    }

    public com.connecterra.alepc.api.EPCPatterns getCacheContent() {
        EPCPatterns ePCPatterns = this.b.getCacheContent();
        try {
            return EPCPatternsAdapter.axisToALE(ePCPatterns);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

