/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.axis.adapters;

import com.connecterra.alepc.api.AccessReport;
import com.connecterra.alepc.api.PCStatus;
import com.connecterra.alepc.api.PCTerminationCondition;
import com.connecterra.alepc.api.PCWriteReport;
import com.connecterra.alepc.axis.adapters.AccessReportAdapter;
import com.connecterra.alepc.axis.schema.EPC;
import com.connecterra.alepc.axis.schema.FailedLogicalReaders;
import com.connecterra.alepc.axis.schema.PhysicalReaders;
import com.connecterra.alepc.axis.schema.Status;
import com.connecterra.alepc.axis.schema.TerminationCondition;
import com.connecterra.i18n.I18N;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class PCWriteReportAdapter
implements PCWriteReport {
    private com.connecterra.alepc.axis.schema.PCWriteReport b;

    public static com.connecterra.alepc.axis.schema.PCWriteReport aleToAxis(PCWriteReport pCWriteReport) {
        if (pCWriteReport == null) {
            return null;
        }
        if (pCWriteReport instanceof PCWriteReportAdapter) {
            return ((PCWriteReportAdapter)pCWriteReport).getAxisWriteReport();
        }
        return new PCWriteReportAdapter(pCWriteReport).getAxisWriteReport();
    }

    public static PCWriteReport axisToALE(com.connecterra.alepc.axis.schema.PCWriteReport pCWriteReport) throws URISyntaxException {
        return pCWriteReport == null ? null : new PCWriteReportAdapter(pCWriteReport);
    }

    public static PCStatus axisToALEStatus(Status status) {
        if (status == Status.SUCCESSFUL) {
            return PCStatus.SUCCESSFUL;
        }
        if (status == Status.NONE_IN_FIELD) {
            return PCStatus.NONE_IN_FIELD;
        }
        if (status == Status.NOT_WRITTEN) {
            return PCStatus.NOT_WRITTEN;
        }
        if (status == Status.VERIFY_ERROR) {
            return PCStatus.VERIFY_ERROR;
        }
        if (status == Status.MULTIPLE_IN_FIELD) {
            return PCStatus.MULTIPLE_IN_FIELD;
        }
        if (status == Status.LOCKED) {
            return PCStatus.LOCKED;
        }
        if (status == Status.INCOMPATIBLE_TAG_TYPE) {
            return PCStatus.INCOMPATIBLE_TAG_TYPE;
        }
        if (status == Status.READ_ONLY) {
            return PCStatus.READ_ONLY;
        }
        if (status == Status.CACHE_EMPTY) {
            return PCStatus.CACHE_EMPTY;
        }
        if (status == Status.READER_BUSY) {
            return PCStatus.READER_BUSY;
        }
        if (status == Status.READER_ERROR) {
            return PCStatus.READER_ERROR;
        }
        if (status == Status.ENGINE_ERROR) {
            return PCStatus.ENGINE_ERROR;
        }
        throw new IllegalArgumentException(I18N.get("Unknown status \"{0}\"", status));
    }

    public static Status aleToAxisStatus(PCStatus pCStatus) {
        if (pCStatus == PCStatus.SUCCESSFUL) {
            return Status.SUCCESSFUL;
        }
        if (pCStatus == PCStatus.NONE_IN_FIELD) {
            return Status.NONE_IN_FIELD;
        }
        if (pCStatus == PCStatus.NOT_WRITTEN) {
            return Status.NOT_WRITTEN;
        }
        if (pCStatus == PCStatus.VERIFY_ERROR) {
            return Status.VERIFY_ERROR;
        }
        if (pCStatus == PCStatus.MULTIPLE_IN_FIELD) {
            return Status.MULTIPLE_IN_FIELD;
        }
        if (pCStatus == PCStatus.LOCKED) {
            return Status.LOCKED;
        }
        if (pCStatus == PCStatus.INCOMPATIBLE_TAG_TYPE) {
            return Status.INCOMPATIBLE_TAG_TYPE;
        }
        if (pCStatus == PCStatus.READ_ONLY) {
            return Status.READ_ONLY;
        }
        if (pCStatus == PCStatus.CACHE_EMPTY) {
            return Status.CACHE_EMPTY;
        }
        if (pCStatus == PCStatus.READER_BUSY) {
            return Status.READER_BUSY;
        }
        if (pCStatus == PCStatus.READER_ERROR) {
            return Status.READER_ERROR;
        }
        if (pCStatus == PCStatus.ENGINE_ERROR) {
            return Status.ENGINE_ERROR;
        }
        throw new IllegalArgumentException(I18N.get("Unknown status \"{0}\"", pCStatus));
    }

    private PCWriteReportAdapter(PCWriteReport pCWriteReport) {
        Serializable serializable;
        Object object;
        this.b = new com.connecterra.alepc.axis.schema.PCWriteReport();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(pCWriteReport.getDate());
        this.b.setDate(calendar);
        this.b.setSavantID(pCWriteReport.getSavantID());
        this.b.setSpecName(pCWriteReport.getSpecName());
        this.b.setCacheName(pCWriteReport.getCacheName());
        this.b.setApplicationData(pCWriteReport.getApplicationData());
        this.b.setWasSuccessful(pCWriteReport.wasSuccessful());
        PCStatus pCStatus = pCWriteReport.getStatus();
        this.b.setStatus(Status.fromString(pCStatus.toString()));
        List list = pCWriteReport.getPhysicalReaderNames();
        if (list != null) {
            object = new PhysicalReaders();
            ((PhysicalReaders)object).setPhysicalReader(list.toArray(new String[list.size()]));
            this.b.setPhysicalReaders((PhysicalReaders)object);
        }
        if ((object = pCWriteReport.getFailedLogicalReaderNames()) != null) {
            serializable = new FailedLogicalReaders();
            ((FailedLogicalReaders)serializable).setLogicalReader(object.toArray(new String[object.size()]));
            this.b.setFailedLogicalReaders((FailedLogicalReaders)serializable);
        }
        this.b.setTotalTrials(pCWriteReport.getTotalTrials());
        this.b.setTotalMilliseconds(pCWriteReport.getTotalMilliseconds());
        this.b.setCacheSize(pCWriteReport.getCacheSize());
        serializable = pCWriteReport.getEPC();
        this.b.setEpc(serializable == null ? null : new EPC(((URI)serializable).toString()));
        this.b.setSuccessfulLogicalReader(pCWriteReport.getSuccessfulLogicalReaderName());
        this.b.setSuccessfulPhysicalReader(pCWriteReport.getSuccessfulPhysicalReaderName());
        this.b.setFailureInfo(pCWriteReport.getFailureInfo());
        PCTerminationCondition pCTerminationCondition = pCWriteReport.getTerminationCondition();
        if (pCTerminationCondition != null) {
            this.b.setTerminationCondition(TerminationCondition.fromString(pCTerminationCondition.toString()));
        }
        if (pCWriteReport.getAccessReports() != null) {
            com.connecterra.alepc.axis.schema.AccessReport[] accessReportArray = new com.connecterra.alepc.axis.schema.AccessReport[pCWriteReport.getAccessReports().size()];
            for (int i = 0; i < accessReportArray.length; ++i) {
                accessReportArray[i] = AccessReportAdapter.aleToAxis((AccessReport)pCWriteReport.getAccessReports().get(i));
            }
            this.b.setAccessReport(accessReportArray);
        } else {
            this.b.setAccessReport(new com.connecterra.alepc.axis.schema.AccessReport[0]);
        }
    }

    private PCWriteReportAdapter(com.connecterra.alepc.axis.schema.PCWriteReport pCWriteReport) throws URISyntaxException {
        this.b = pCWriteReport;
        if (this.b.getEpc() != null) {
            new URI(this.b.getEpc().toString());
        }
    }

    public com.connecterra.alepc.axis.schema.PCWriteReport getAxisWriteReport() {
        return this.b;
    }

    public long getDate() {
        return this.b.getDate().getTimeInMillis();
    }

    public String getSavantID() {
        return this.b.getSavantID();
    }

    public String getSpecName() {
        return this.b.getSpecName();
    }

    public String getCacheName() {
        return this.b.getCacheName();
    }

    public String getApplicationData() {
        return this.b.getApplicationData();
    }

    public boolean wasSuccessful() {
        return this.b.isWasSuccessful();
    }

    public PCStatus getStatus() {
        return PCWriteReportAdapter.axisToALEStatus(this.b.getStatus());
    }

    public List getPhysicalReaderNames() {
        PhysicalReaders physicalReaders = this.b.getPhysicalReaders();
        if (physicalReaders == null || physicalReaders.getPhysicalReader() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(physicalReaders.getPhysicalReader()));
    }

    public List getFailedLogicalReaderNames() {
        FailedLogicalReaders failedLogicalReaders = this.b.getFailedLogicalReaders();
        if (failedLogicalReaders == null || failedLogicalReaders.getLogicalReader() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(failedLogicalReaders.getLogicalReader()));
    }

    public long getTotalMilliseconds() {
        return this.b.getTotalMilliseconds();
    }

    public int getTotalTrials() {
        return this.b.getTotalTrials();
    }

    public long getCacheSize() {
        return this.b.getCacheSize();
    }

    public URI getEPC() {
        if (this.b.getEpc() == null) {
            return null;
        }
        try {
            return new URI(this.b.getEpc().toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public String getSuccessfulLogicalReaderName() {
        return this.b.getSuccessfulLogicalReader();
    }

    public String getSuccessfulPhysicalReaderName() {
        return this.b.getSuccessfulPhysicalReader();
    }

    public String getFailureInfo() {
        return this.b.getFailureInfo();
    }

    public PCTerminationCondition getTerminationCondition() {
        TerminationCondition terminationCondition = this.b.getTerminationCondition();
        if (terminationCondition == null) {
            return null;
        }
        if (terminationCondition == TerminationCondition.FAILURE) {
            return PCTerminationCondition.FAILURE;
        }
        if (terminationCondition == TerminationCondition.TRIGGER) {
            return PCTerminationCondition.TRIGGER;
        }
        if (terminationCondition == TerminationCondition.DURATION) {
            return PCTerminationCondition.DURATION;
        }
        if (terminationCondition == TerminationCondition.TRIALS) {
            return PCTerminationCondition.TRIALS;
        }
        if (terminationCondition == TerminationCondition.UNDEFINE) {
            return PCTerminationCondition.UNDEFINE;
        }
        throw new IllegalArgumentException(I18N.get("Unknown termination condition \"{0}\"", terminationCondition));
    }

    public List getAccessReports() {
        int n = this.b.getAccessReport().length;
        ArrayList<AccessReport> arrayList = new ArrayList<AccessReport>(n);
        for (int i = 0; i < n; ++i) {
            try {
                arrayList.add(AccessReportAdapter.axisToALE(this.b.getAccessReport()[i]));
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }
}

