/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.axis.adapters;

import com.connecterra.alepc.api.DataSpec;
import com.connecterra.alepc.api.EPCCacheDataSpec;
import com.connecterra.alepc.api.LiteralDataSpec;
import com.connecterra.alepc.api.PCSpecValidationException;
import com.connecterra.alepc.api.ParamDataSpec;
import com.connecterra.alepc.api.PasswordOpSpec;
import com.connecterra.alepc.axis.adapters.DataSpecAdapter;
import com.connecterra.alepc.axis.adapters.OpSpecAdapter;
import com.connecterra.alepc.axis.schema.PasswordOperationSpec;
import java.net.URISyntaxException;

public class PasswordOpSpecAdapter
implements PasswordOpSpec,
OpSpecAdapter {
    private PasswordOperationSpec h;
    private DataSpec g;

    public static PasswordOperationSpec aleToAxis(PasswordOpSpec passwordOpSpec) {
        if (passwordOpSpec == null) {
            return null;
        }
        if (passwordOpSpec instanceof PasswordOpSpecAdapter) {
            return ((PasswordOpSpecAdapter)passwordOpSpec).e();
        }
        return new PasswordOpSpecAdapter(passwordOpSpec).e();
    }

    public static PasswordOpSpec axisToALE(PasswordOperationSpec passwordOperationSpec) throws URISyntaxException, PCSpecValidationException {
        return passwordOperationSpec == null ? null : new PasswordOpSpecAdapter(passwordOperationSpec);
    }

    public PasswordOpSpecAdapter(DataSpec dataSpec) {
        this.h = new PasswordOperationSpec();
        this.g = dataSpec;
        if (dataSpec instanceof LiteralDataSpec) {
            this.h.setLiteral(((LiteralDataSpec)dataSpec).getValue().toString());
        } else if (dataSpec instanceof ParamDataSpec) {
            this.h.setParam(((ParamDataSpec)dataSpec).getParamName());
        } else if (dataSpec instanceof EPCCacheDataSpec) {
            this.h.setEpcCache(((EPCCacheDataSpec)dataSpec).getEPCCache());
        }
    }

    PasswordOpSpecAdapter(PasswordOpSpec passwordOpSpec) {
        this(passwordOpSpec.getDataSpec());
    }

    private PasswordOpSpecAdapter(PasswordOperationSpec passwordOperationSpec) throws URISyntaxException, PCSpecValidationException {
        this.h = passwordOperationSpec;
        this.g = passwordOperationSpec.getLiteral() != null ? DataSpecAdapter.createLiteral(passwordOperationSpec.getLiteral()) : DataSpecAdapter.createOther(passwordOperationSpec.getEpcCache(), passwordOperationSpec.getParam());
    }

    public DataSpec getDataSpec() {
        return this.g;
    }

    private PasswordOperationSpec e() {
        return this.h;
    }
}

