/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.httpMessage.HTTPMessage;
import com.connecterra.httpMessage.HTTPMessageCodec;
import com.connecterra.httpMessage.HTTPServer;
import com.connecterra.httpMessage.SocketHTTPStream;
import com.connecterra.httpMessage.TimeoutException;
import com.connecterra.i18n.I18N;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Date;
import java.util.logging.Logger;

public abstract class AbstractHTTPListener
implements Runnable {
    private HTTPServer c;
    private InetAddress b;
    protected static Logger s_log = Logger.getLogger("com.connecterra.util.AbstractHTTPListener");

    public AbstractHTTPListener(Socket socket) throws IOException {
        SocketHTTPStream socketHTTPStream = new SocketHTTPStream(socket);
        this.c = new HTTPServer(new HTTPMessageCodec(socketHTTPStream));
        SocketAddress socketAddress = socket.getRemoteSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            this.b = ((InetSocketAddress)socketAddress).getAddress();
        }
    }

    public abstract Response processRequest(String var1, byte[] var2, InetAddress var3);

    public abstract String getServerName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!this.c.isClosed()) {
                HTTPMessage hTTPMessage;
                try {
                    Response response = null;
                    hTTPMessage = null;
                    HTTPMessage hTTPMessage2 = this.c.receiveHTTPRequest(0);
                    if (hTTPMessage2 == null) {
                        break;
                    }
                    String string = hTTPMessage2.getRequestURI();
                    byte[] byArray = hTTPMessage2.getContent();
                    response = this.processRequest(string, byArray, this.b);
                    hTTPMessage = new HTTPMessage();
                    hTTPMessage.setResponse(response.c, response.d);
                    hTTPMessage.setHeader("Content-type", "text/plain");
                    this.c.sendHTTPResponse(hTTPMessage, 0);
                }
                catch (SocketException socketException) {
                    s_log.severe(I18N.get("{0} {1}: incoming exception ({2}).", (Object)this.getServerName(), (Object)new Date(), (Object)socketException.getLocalizedMessage()));
                }
                catch (Exception exception) {
                    s_log.severe(I18N.get("{0} {1}: incoming exception ({2}).", (Object)this.getServerName(), (Object)new Date(), (Object)exception.getLocalizedMessage()));
                    hTTPMessage = new HTTPMessage();
                    hTTPMessage.setResponse(500, "Server Error");
                    hTTPMessage.setHeader("Connection", "close");
                    hTTPMessage.setHeader("Content-type", "text/plain");
                    try {
                        this.c.sendHTTPResponse(hTTPMessage, 0);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (TimeoutException timeoutException) {
                        timeoutException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    s_log.info(I18N.get("{0} {1}: incoming exception ({2}).", (Object)this.getServerName(), (Object)new Date(), (Object)exception.getLocalizedMessage()));
                }
            }
        }
        finally {
            this.c.close();
        }
    }

    protected class Response {
        int c = 200;
        String d = null;

        public Response(int n, String string) {
            this.c = n;
            this.d = string;
        }
    }
}

