/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.httpMessage.DecodeException;
import com.connecterra.httpMessage.HTTPConnection;
import com.connecterra.httpMessage.HTTPMessage;
import com.connecterra.httpMessage.HTTPMessageCodec;
import com.connecterra.httpMessage.ProtocolException;
import com.connecterra.httpMessage.TimeoutException;
import com.connecterra.httpMessage.URL;
import com.connecterra.i18n.I18N;
import java.io.IOException;
import java.util.logging.Logger;

public class HTTPClient
extends HTTPConnection {
    private static Logger i = Logger.getLogger("com.connecterra.httpMessage.HTTPClient");
    private boolean k = false;
    private String j = null;
    private String l = null;
    private boolean h = false;

    public HTTPClient(HTTPMessageCodec hTTPMessageCodec) {
        super(hTTPMessageCodec);
    }

    public HTTPClient(HTTPMessageCodec hTTPMessageCodec, String string, String string2) {
        super(hTTPMessageCodec);
        if (string == null ^ string2 == null) {
            throw new IllegalArgumentException(I18N.get("Neither or both of username/password must be provided"));
        }
        this.k = true;
        this.j = string;
        this.l = string2;
    }

    public void sendHTTPRequest(HTTPMessage hTTPMessage, int n) throws IOException, TimeoutException, InterruptedException {
        if (hTTPMessage.getRequestMethod() == null) {
            throw new IllegalArgumentException(I18N.get("Not a request: {0}", hTTPMessage));
        }
        if (!hTTPMessage.getHTTPVersion().equals("1.1") && this.k) {
            this.clearRequestPersistent(hTTPMessage);
        }
        this.h = this.isRequestingPersistent(hTTPMessage);
        String string = hTTPMessage.getRequestURI();
        String string2 = null;
        try {
            string2 = hTTPMessage.getSingleHeaderValue("Host");
        }
        catch (ProtocolException protocolException) {
            throw new IllegalArgumentException(I18N.get("Multi-valued Host header: {0}", protocolException.getLocalizedMessage()));
        }
        if (this.k) {
            if (string.startsWith("/")) {
                if (string2 == null) {
                    throw new IllegalArgumentException(I18N.get("Request has no Host header: {0}", hTTPMessage));
                }
                string = "http://" + string2 + string;
            }
            if (this.j != null) {
                hTTPMessage.setBasicAuthorizationHeader("Proxy-Authorization", this.j, this.l);
            }
        } else if (string.toLowerCase().startsWith("http")) {
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (DecodeException decodeException) {
                throw (IllegalArgumentException)new IllegalArgumentException(I18N.get("Bad request URI")).initCause(decodeException);
            }
            string = uRL.getPathAndQuery();
            if (string2 == null) {
                string2 = uRL.getHost() + ":" + uRL.getPort();
            }
        }
        hTTPMessage.setRequest(hTTPMessage.getRequestMethod(), string);
        if (string2 != null) {
            hTTPMessage.setHeader("Host", string2);
        }
        i.fine("Forwarding request: " + hTTPMessage.toString(32));
        this.sendHTTP(hTTPMessage, n);
    }

    public void finishInterruptedSend(int n) throws IOException, TimeoutException, InterruptedException {
        this.finishInterrupted(n);
    }

    public HTTPMessage receiveHTTPResponse(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        HTTPMessage hTTPMessage = this.receiveHTTP(n);
        if (hTTPMessage == null) {
            return null;
        }
        if (hTTPMessage.getResponseCode() == -1) {
            throw new ProtocolException(I18N.get("Expected response, got: {0}", hTTPMessage.toString(0)));
        }
        if (!this.h || !this.isRequestingPersistent(hTTPMessage)) {
            i.fine("Closing non-persistent");
            this.close();
        }
        i.fine("Returning response: " + hTTPMessage.toString(32));
        return hTTPMessage;
    }
}

