/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.modbus.server;

import com.connecterra.modbus.protocol.ProtocolException;
import com.connecterra.modbus.server.MODBUSDataModel;
import com.connecterra.modbus.server.ServerConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;

public class MODBUSServer {
    private static final Logger d = Logger.getLogger("com.connecterra.modbus.server");
    private ServerSocket c;
    private MODBUSDataModel b;

    public MODBUSServer(int n, MODBUSDataModel mODBUSDataModel) throws IOException {
        this.c = new ServerSocket(n);
        this.b = mODBUSDataModel;
    }

    public void serve() throws IOException {
        while (true) {
            Socket socket = this.c.accept();
            socket.setTcpNoDelay(true);
            final ServerConnection serverConnection = new ServerConnection(socket, this.b);
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        serverConnection.process();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        d.fine("Protocol exception: " + iOException.getMessage());
                        return;
                    }
                    catch (ProtocolException protocolException) {
                        protocolException.printStackTrace();
                        d.fine("Protocol exception: " + protocolException.getMessage());
                        return;
                    }
                }
            });
            thread.start();
        }
    }
}

